import { useSelector, useDispatch } from 'react-redux';
import { Link, useLocation, useNavigate } from 'react-router-dom';
import SearchBar from '../../Componets/SearchBar/SearchBar';
import BusinessInfo from './BusinessInfo/BusinessInfo';
import ContactDetails from './ContactDetails/ContactDetails';
import BusinessYearTitle from './BusinessYearTitle/BusinessYearTitle';
import Media from './Media/Media';
import MetaData from './MetaData/MetaData';
import { useAppSelector } from '../../Hooks/Hooks';
import { updateAddPostData } from '../../Appstore/Slice/Storevalues/AddStoreSlice';
import addstore from "../../assets/Images/businessinfo.png"
import addstore2 from "../../assets/Images/addstore12.png"
import addstore3 from "../../assets/Images/addstore3.png"
import addstore4 from "../../assets/Images/addstore4.png"
import addstore5 from "../../assets/Images/addstore5.png"
import adddark from "../../assets/Images/adddark.png"
import adddark2 from "../../assets/Images/adddark2.png"
import adddark3 from "../../assets/Images/adddark3.png"
import adddark4 from "../../assets/Images/adddark4.png"
import adddark5 from "../../assets/Images/adddark5.png"
import { MdArrowBack } from 'react-icons/md';

const options = [
    {
        key: "BusinessInfo",
        label: "Business Info",
        iconLight: addstore,
        iconDark: adddark,
        component: <BusinessInfo />,
    },
    {
        key: "ContactDetails",
        label: "Contact Details",
        iconLight: addstore2,
        iconDark: adddark2,
        component: <ContactDetails />,
    },
    {
        key: "BusinessYearTitle",
        label: "Business Time & Year Title",
        iconLight: addstore3,
        iconDark: adddark3,
        component: <BusinessYearTitle />,
    },
    {
        key: "Media",
        label: "Media",
        iconLight: addstore4,
        iconDark: adddark4,
        component: <Media />,
    },
    {
        key: "MetaData",
        label: "Meta Data",
        iconLight: addstore5,
        iconDark: adddark5,
        component: <MetaData />,
    },
];

function AddStore() {
    const isSidebarOpen = useSelector((state: any) => state.sidebar.isOpen);
    const navigate = useNavigate();
    const location = useLocation();
    const dispatch = useDispatch();

    const currentPath = location.pathname.split('/');
    const sourcePage = currentPath[1] || 'user-list';

    const currentStepIndex = useAppSelector((state) => state.AddStoreSlice.add_new_post_steps);
    const currentStepKey = options[currentStepIndex - 1]?.key || "BusinessInfo";
    const selectedComponent = options.find(opt => opt.key === currentStepKey)?.component;

    const handleStepChange = (index: number) => {
        dispatch(updateAddPostData(index + 1));
    };

    return (
        <div className={`bg-primary ${isSidebarOpen ? 'xl:pl-20' : 'xl:pl-72'}`}>
            <SearchBar />




            <div className="px-4  xl:px-6">
                <div className="w-full flex justify-between items-center gap-2">
                    {/* Left Content */}
                    <div className="flex flex-col">
                        {/* Header */}
                        <div className="flex justify-between border-t-[#F2F2F2] py-3">
                            <h2 className="text-textcolor font-poppins text-xl font-semibold pt-3">
                                Add Store
                            </h2>
                        </div>

                        {/* Breadcrumb */}
                        <div className="mb-4 flex items-center gap-2">
                            <Link to="/dashboard">
                                <h3 className="text-base font-semibold text-[#3A3A3A] font-poppins">
                                    Dashboard
                                </h3>
                            </Link>
                            <div className="h-1 w-1 rounded-full bg-[#E0E0E0]"></div>
                            <h3 className="text-base text-[#858585] font-poppins">Add Store</h3>
                        </div>
                    </div>

                    {/* Back Button */}
                    <button
                        onClick={() => navigate(-1)} // go back
                        className="flex items-center gap-2 px-4 py-[6px] text-white cursor-pointer bggradient font-poppins rounded-md"
                    >
                        <MdArrowBack size={20} />
                        Back
                    </button>
                </div>
            </div>

            {/* Main Form */}
            <div className="mx-auto w-[97%] border border-bordercolor mt-12 rounded-lg p-4">
                <div className="md:flex  flex-col">
                    {/* Sidebar Options */}
                    <div className="flex  gap-4   md:flex-row flex-col">
                        {options.map(({ key, label, iconLight, iconDark, icon }, index) => (
                            <button
                                key={key}
                                onClick={() => handleStepChange(index)}
                                className={`flex items-center gap-2 px-4 py-3.5 rounded-xl cursor-pointer lg:w-[300px] md:w-[220px]
                                    ${currentStepKey === key ? "bggradient" : "border border-bordercolor"}`}
                            >
                                {icon ? (
                                    <span className={`${currentStepKey === key ? "text-[#FFFFFF]" : "text-textcolor"} dark:text-[#FFFFFF]`}>{icon}</span>
                                ) : (
                                    <>
                                        <img src={currentStepKey === key ? iconDark : iconLight} className="block w-5 h-5 dark:hidden" />
                                        <img src={iconDark} className="hidden w-5 h-5 dark:block" />
                                    </>
                                )}
                                <p className={`font-poppins text-sm font-normal ${currentStepKey === key ? "text-[#FFFFFF]" : "text-[#5B5B5B]  dark:text-[#FFF] "}`}>{label}</p>
                            </button>
                        ))}
                    </div>

                    {/* Component Display */}
                    <div className="w-full mt-4">{selectedComponent}</div>
                </div>
            </div>
        </div>
    );
}

export default AddStore;
