import React, { useState, useRef, useMemo, useEffect } from "react";
import { useDispatch } from "react-redux";
import JoditEditor from "jodit-react";
import { useAppSelector } from "../../../Hooks/Hooks";
import { StoreaddDescriptionState } from "../../../Appstore/Slice/Storevalues/StoreaddDescription";

const StoreDescription = () => {
    const dispatch = useDispatch();
    const editor = useRef(null);
    const { service_description } = useAppSelector((state) => state.StoreaddDescription);

    const [content, setContent] = useState(service_description || "");

    // Ensure local state is in sync with Redux on mount
    useEffect(() => {
        if (service_description && service_description !== content) {
            setContent(service_description);
        }
    }, [service_description]);

    const config = useMemo(
        () => ({
            readonly: false,
            placeholder: "Store description typing...",
            toolbar: true,
            buttons: [
                "bold", "italic", "underline", "strike", "|",
                "font", "fontsize", "forecolor", "backcolor", "|",
                "ul", "ol", "outdent", "indent", "|",
                "align", "alignleft", "aligncenter", "alignright", "alignjustify", "|",
                "link", "image", "table", "video", "|",
                "undo", "redo", "removeformat", "clear", "|", "fullsize",
            ],
            spellcheck: true,
            showCharsCounter: false,
            showWordsCounter: false,
            height: 400,
            askBeforePasteHTML: false,
            cleanHTML: {
                removeStyles: true,
                removeTags: ["style", "script"],
            },
        }),
        []
    );

    const handleContentChange = (newContent: string) => {
        setContent(newContent);
        dispatch(StoreaddDescriptionState({ service_description: newContent }));
    };

    return (
        <div className="w-full overflow-hidden">
            <label
                htmlFor="businessDescription"
                className="block text-sm font-normal font-poppins text-[#000000]"
            >
                Store Description<span className="text-[#FF0000]"> *</span>
            </label>
            <div className="mt-2">
                <JoditEditor
                    ref={editor}
                    value={content}
                    config={config}
                    tabIndex={1}
                    onBlur={handleContentChange}
                    onChange={handleContentChange}
                />
            </div>
        </div>
    );
};

export default StoreDescription;
