"use client";
import { useDispatch } from "react-redux";
import { useEffect, useState } from "react";
import { MdOutlineCheck, MdOutlineChevronRight } from "react-icons/md";
import { useAppSelector } from "../../../Hooks/Hooks";
import {
  setSubCategoryList,
  toggleSubCategorySelection,
  resetSubCategoryState,
  removeSubCategory,
  resetonlyselect,
} from "../../../Appstore/Slice/SubCategorySlice";
import { UseGetSubcategory } from "../../../Appstore/Api/UseGetSubcategory";

interface CategoryDropdownProps {
  required?: boolean;
}

const SubCategoryDropdown: React.FC<CategoryDropdownProps> = () => {
  const dispatch = useDispatch();
  const category_id = useAppSelector((state) => state.category.selectedCategory?.id);
  const selectedSubCategories = useAppSelector((state) => state.subcategory.selectedSubCategories);
  const subCategories = useAppSelector((state) => state.subcategory.subCategories);


  console.log("category_idcategory_idcategory_id", category_id)


  console.log("selectedSubCategories", selectedSubCategories)

  const [searchValue, setSearchValue] = useState<string>("");
  const [showDropdown, setShowDropdown] = useState<boolean>(false);
  const [rotate, setRotate] = useState<boolean>(false);

  const { data, isLoading, isSuccess, isError } = UseGetSubcategory(category_id);

  useEffect(() => {
    setSearchValue("");
  }, [category_id]);

  useEffect(() => {
    if (isSuccess) {
      if (data?.subCategoryData?.length > 0) {
        dispatch(setSubCategoryList(data.subCategoryData));
      } else {
        dispatch(setSubCategoryList([]));
      }
    }
  }, [data, isSuccess]);

  const handleToggleSelection = (subcategory: any) => {
    dispatch(toggleSubCategorySelection(subcategory));
    setSearchValue("");
  };

  const handleFocus = () => {
    if (category_id) {
      setShowDropdown(true);
      setRotate(true);
    }
  };

  const handleBlur = () => {
    setTimeout(() => {
      setShowDropdown(false);
      setRotate(false);
    }, 100);
  };

  const handleToggle = () => {
    if (category_id) {
      setShowDropdown((prev) => !prev);
      setRotate((prev) => !prev);
    }
  };

  const filteredSubcategories = subCategories.filter((item) =>
    item.subcategory_name.toLowerCase().includes(searchValue.toLowerCase())
  );

  const isSelected = (id: number) =>
    selectedSubCategories.find((sc) => sc.id === id) !== undefined;

  return (
    <div className="w-full flex flex-col relative h-full">
      <label htmlFor="subcategory" className="font-poppins text-sm  font-normal text-textcolor">
        Sub Category<span className="text-[#F21818] pl-[1px]">*</span>
      </label>

      <div className="relative mt-1 flex items-center cursor-pointer">
        <input
          type="text"
          id="subcategory"
          autoComplete="off"
          spellCheck="false"
          className="w-full rounded-lg border border-bordercolor cursor-pointer focus:border-toggalbtcolorborder text-textcolor bg-primary px-4 py-2.5 my-1 placeholder:text-placeholdercolor placeholder:text-sm focus:outline-none"
          placeholder={
            category_id
              ? "Search or select subcategories"
              : "Please select a category first"
          }
          value={searchValue}
          onFocus={handleFocus}
          onBlur={handleBlur}
          onChange={(e) => setSearchValue(e.target.value)}
          disabled={!category_id}
        />
        <div
          className={`absolute right-2 text-xl cursor-pointer transition-transform ${rotate ? "rotate-90" : "-rotate-90"}`}
          onClick={handleToggle}
        >
          <MdOutlineChevronRight />
        </div>
      </div>

      {selectedSubCategories.length > 0 && (
        <div className="flex flex-wrap mt-2 gap-2">
          {selectedSubCategories.map((subcategory) => (
            <span
              key={subcategory.id}
              className="flex items-center bg-[#1c5bb9c4] text-white px-3 py-1 rounded-full text-sm font-poppins"
            >
              {subcategory.subcategory_name}
              <button
                className="ml-2 text-red-500 hover:text-red-700"
                onClick={() => dispatch(removeSubCategory(subcategory.id))}
              >
                ×
              </button>
            </span>
          ))}
        </div>
      )}

      {showDropdown && (
        <ul className="absolute top-[5rem] left-0 z-50 w-full bg-primary text-textcolor rounded-lg shadow-lg max-h-[200px] overflow-y-auto  border border-bordercolor mt-1">
          {isLoading ? (
            <li className="px-4 py-2 font-poppins text-center text-gray-500">Loading...</li>
          ) : isError ? (
            <li className="px-4 py-2 font-poppins text-center text-red-500">
              Failed to load subcategories
            </li>
          ) : filteredSubcategories.length > 0 ? (
            filteredSubcategories.map((item) => (
              <li
                key={item.id}
                className="px-4 py-2 cursor-pointer font-poppins hover:bg-gray-200 text-textcolor flex justify-between items-center"
                onMouseDown={() => handleToggleSelection(item)}
              >
                {item.subcategory_name}
                {isSelected(item.id) && (
                  <MdOutlineCheck className="text-[#6565657a] text-lg" />
                )}
              </li>
            ))
          ) : (
            <li className="px-4 py-2 font-poppins text-center text-gray-500">No subcategories found</li>
          )}
        </ul>
      )}
    </div>
  );
};

export default SubCategoryDropdown;
