"use client";
import { useDispatch } from "react-redux";
import { useEffect, useState } from "react";
import { MdOutlineCheck, MdOutlineChevronRight } from "react-icons/md";
import { UserVendorList } from "../../../Appstore/Api/UserVendorList";
import { useAppSelector } from "../../../Hooks/Hooks";
import {  selectVendor, setVendorList } from "../../../Appstore/Slice/VendorSlice";

interface CategoryDropdownProps {
  required?: boolean;
}

const Vendordropdwon: React.FC<CategoryDropdownProps> = () => {
  const dispatch = useDispatch();
  const { data, isLoading } = UserVendorList();

  const vendors = useAppSelector((state) => state.vendor.vendors);
  const selectedVendor = useAppSelector((state) => state.vendor.selectedVendor);

  console.log("selectedVendorselectedVendorselectedVendor vendor detaul ", selectedVendor?.first_name, selectedVendor?.last_name)

  const [searchValue, setSearchValue] = useState<string>("");
  const [showDropdown, setShowDropdown] = useState<boolean>(false);
  const [rotate, setRotate] = useState<boolean>(false);

  useEffect(() => {
    if (data?.vendors) {
      dispatch(setVendorList(data.vendors));
    }
  }, [data]);


 

  useEffect(() => {
    if (selectedVendor) {
      setSearchValue(`${selectedVendor.first_name} ${selectedVendor.last_name}`.trim());
    }
  }, [selectedVendor]);

  const handleSelectVendor = (vendor: any | null) => {
    if (vendor === null) {
      setSearchValue("");
      dispatch(selectVendor(null));
      return;
    }

    setSearchValue(`${vendor.first_name} ${vendor.last_name}`.trim());
    dispatch(selectVendor(vendor));
    setShowDropdown(false);
    setRotate(false);
  };


  const handleFocus = () => {
    setShowDropdown(true);
    setRotate(true);
  };

  const handleBlur = () => {
    setTimeout(() => {
      setShowDropdown(false);
      setRotate(false);
    }, 100);
  };

  const handleToggle = () => {
    setShowDropdown((prev) => !prev);
    setRotate((prev) => !prev);
  };

  const filteredVendors = vendors.filter((vendor) =>
    `${vendor.first_name} ${vendor.last_name}`
      .toLowerCase()
      .includes(searchValue.toLowerCase())
  );

  return (
    <div className="w-full flex flex-col relative h-full">
      <label htmlFor="vendor" className="font-poppins text-sm font-normal text-textcolor">
        Vendor<span className="text-[#F21818] pl-[1px]">*</span>
      </label>

      <div className="relative mt-1 flex items-center cursor-pointer">
        <input
          type="text"
          id="vendor"
          autoComplete="off"
          spellCheck="false"
          className="w-full rounded-lg border border-bordercolor cursor-pointer focus:border-toggalbtcolorborder text-textcolor bg-primary px-4 py-2.5 my-1 placeholder:text-placeholdercolor placeholder:text-sm focus:outline-none"
          placeholder="Search or select vendor"
          value={searchValue}
          onFocus={handleFocus}
          onBlur={handleBlur}
          onChange={(e) => setSearchValue(e.target.value)}
        />
        <div
          className={`absolute right-2 text-xl cursor-pointer transition-transform ${rotate ? "rotate-90" : "-rotate-90"}`}
          onClick={handleToggle}
        >
          <MdOutlineChevronRight className="text-xl" />
        </div>
      </div>

      {selectedVendor && (
        <div className="flex flex-wrap mt-2 gap-2">
          <span className="flex items-center bg-[#1c5bb9c4] text-white px-3 py-1 rounded-full text-sm font-poppins">
            {selectedVendor.first_name} {selectedVendor.last_name}
            <button
              className="ml-2 text-red-500 hover:text-red-700"
              onClick={() => handleSelectVendor(null)}
            >
              ×
            </button>
          </span>
        </div>
      )}

      {showDropdown && (
        <ul className="absolute top-[5rem] left-0 w-full bg-primary text-textcolor rounded-lg shadow-lg max-h-[200px] overflow-y-auto z-10 border border-bordercolor mt-1">
          {isLoading ? (
            <li className="px-4 py-2 font-poppins text-center text-gray-500">Loading vendors...</li>
          ) : filteredVendors.length > 0 ? (
            filteredVendors.map((vendor) => (
              <li
                key={vendor.id}
                className="px-4 py-2 cursor-pointer font-poppins hover:bg-gray-200 text-textcolor flex justify-between items-center"
                onMouseDown={() => handleSelectVendor(vendor)}
              >
                {vendor.first_name} {vendor.last_name}
                {selectedVendor?.id === vendor.id && (
                  <MdOutlineCheck className="text-[#6565657a] text-lg" />
                )}
              </li>
            ))
          ) : (
            <li className="px-4 py-2 font-poppins text-center text-gray-500">No vendors found</li>
          )}
        </ul>
      )}
    </div>
  );
};

export default Vendordropdwon;
