import React from 'react'
import OpenDay from './OpenDay'
import CloseDay from './CloseDay'
import OpenTime from './OpenTime'
import CloseTime from './CloseTime'
import MonthDropdown from './MonthDropdwn'
import YearDropdown from './YearDropdwon'
import { useAppDispatch, useAppSelector } from '../../../Hooks/Hooks'
import { updateAddPostData } from '../../../Appstore/Slice/Storevalues/AddStoreSlice'
import toast from 'react-hot-toast'

function BusinessYearTitle() {


  const formData = useAppSelector((state) => state.AddStoreSlice);

  const dispatch = useAppDispatch()


  console.log("formDataformDatamonu", formData.published_year)

  const selectedDays = useAppSelector((state) => state.openDay.selectedDays);


  const handleNextStep = () => {

    //  all filed are required

    if (selectedDays?.length == 0 || !formData.open_time || !formData.close_time || !formData.published_month || !formData.published_year) {
      toast.error("All filed are required")
      return;
    }


    // Increment add_new_post_steps by 1
    if ((formData.add_new_post_steps ?? 0) < 5) {
      dispatch(
        updateAddPostData({
          add_new_post_steps: ((formData.add_new_post_steps ?? 0) + 1) as
            | 1
            | 2
            | 3,
        })
      );
    }
  };



  const handlePreviousStep = () => {
    // Decrement add_new_post_steps by 1
    if ((formData.add_new_post_steps ?? 0) > 1) {
      dispatch(
        updateAddPostData({
          add_new_post_steps: ((formData.add_new_post_steps ?? 0) - 1) as
            | 1
            | 2
            | 3,
        })
      );
    }
  };

  return (
   <div className="w-full flex flex-col mt-4 md:mt-0 p-6 border border-bordercolor rounded-lg gap-6">
      <div className="w-full h-fit grid md:grid-cols-2 gap-4">
        <OpenDay />
        <CloseDay />
        <OpenTime />
        <CloseTime />

      </div>

      <div className=' w-full   flex flex-col  gap-4'>
        <h4 className=' font-poppins   font-medium text-lg  text-[#0046AE] '> Year of Establishment</h4>
        <div className=' w-full   grid  grid-cols-2 gap-4'>
          <MonthDropdown />
          <YearDropdown />
        </div>
      </div>

      {/*  previous and next btn  */}

      <div className=" w-full  flex justify-center   gap-9 items-center">

        {/*  previous btn */}

        <button className="w-fit px-[3rem] py-2 bggradient rounded-lg cursor-pointer font-poppins text-white" onClick={handlePreviousStep} >Previous</button>
        <button className="w-fit px-[3rem] py-2 bggradient rounded-lg cursor-pointer font-poppins text-white" onClick={handleNextStep} >Next</button>


      </div>

    </div>
  )
}

export default BusinessYearTitle
