import React, { useState } from "react";
import { useAppSelector } from "../../../Hooks/Hooks";
import { MdOutlineChevronRight } from "react-icons/md";

const weekDays = [
    "Monday", "Tuesday", "Wednesday",
    "Thursday", "Friday", "Saturday", "Sunday"
];

function CloseDay() {
    const selectedDays = useAppSelector((state) => state.openDay.selectedDays);
    const closedDays = weekDays.filter((day) => !selectedDays.includes(day));

    const [searchValue, setSearchValue] = useState("");
    const [showDropdown, setShowDropdown] = useState(false);
    const [rotate, setRotate] = useState(false);

    const handleToggleDropdown = () => {
        setShowDropdown((prev) => !prev);
        setRotate((prev) => !prev);
    };

    const handleFocus = () => {
        setShowDropdown(true);
        setRotate(true);
    };

    const handleBlur = () => {
        setTimeout(() => {
            setShowDropdown(false);
            setRotate(false);
        }, 150);
    };

    const filteredDays = closedDays.filter((day) =>
        day.toLowerCase().includes(searchValue.toLowerCase())
    );

    return (
        <div className="w-full flex flex-col relative h-full">
            <label htmlFor="closed-days" className="font-poppins text-sm font-medium text-textcolor">
                Closed Days <span className="text-[#F21818] pl-[1px]">*</span>
            </label>

            <div className="relative mt-1 flex items-center cursor-pointer">
                <input
                    type="text"
                    id="closed-days"
                    autoComplete="off"
                    spellCheck="false"
                    className="w-full rounded-lg border border-bordercolor cursor-pointer focus:border-blue-500 text-textcolor bg-primary px-4 py-2.5 my-1 placeholder:text-placeholdercolor placeholder:text-sm focus:outline-none"
                    placeholder="View closed days"
                    value={searchValue}
                    onChange={(e) => setSearchValue(e.target.value)}
                    onFocus={handleFocus}
                    onBlur={handleBlur}
                />
                <div
                    className={`absolute right-2 text-xl cursor-pointer transition-transform ${rotate ? "rotate-90" : "-rotate-90"}`}
                    onClick={handleToggleDropdown}
                >
                    <MdOutlineChevronRight />
                </div>
            </div>

            {/*  selected values show in default */}
            <div className="mt-2 flex flex-wrap gap-2">
                {closedDays.length > 0 ? (
                    closedDays.map((day) => (
                        <span
                            key={day}
                            className="flex items-center bg-[#1c5bb9c4] text-white px-3 py-1 rounded-full text-sm font-poppins"
                        >
                            {day}
                            <button
                                className="ml-2 text-red-500 hover:text-red-700"
                            >
                                ×
                            </button>
                        </span>
                    ))
                ) : (
                    <span className="text-sm text-gray-500 font-poppins">
                        All days are open.
                    </span>
                )}
            </div>

            {showDropdown && (
                <ul className="absolute top-[5rem] left-0 w-full bg-white text-textcolor rounded-lg shadow-lg max-h-[200px] overflow-y-auto z-10 border border-bordercolor mt-1">
                    {filteredDays.length > 0 ? (
                        filteredDays.map((day) => (
                            <li
                                key={day}
                                className="px-4 py-2 font-poppins text-sm hover:bg-gray-100 cursor-default"
                            >
                                {day}
                            </li>
                        ))
                    ) : (
                        <li className="px-4 py-2 font-poppins text-center text-gray-500">
                            All days are open
                        </li>
                    )}
                </ul>
            )}
        </div>
    );
}

export default CloseDay;
