import React, { useEffect, useState } from "react";
import { MdOutlineChevronRight } from "react-icons/md";
import { useAppDispatch, useAppSelector } from "../../../Hooks/Hooks";
import { updateAddPostData } from "../../../Appstore/Slice/Storevalues/AddStoreSlice";

const months = [
  "January", "February", "March", "April", "May", "June",
  "July", "August", "September", "October", "November", "December"
];

function MonthDropdown() {
  const dispatch = useAppDispatch();
  const selectedMonthFromStore = useAppSelector(
    (state) => state.AddStoreSlice.published_month
  );

  const [selectedMonth, setSelectedMonth] = useState("");
  const [showDropdown, setShowDropdown] = useState(false);
  const [rotate, setRotate] = useState(false);

  useEffect(() => {
    if (selectedMonthFromStore) {
      setSelectedMonth(selectedMonthFromStore);
    }
  }, [selectedMonthFromStore]);

  const handleToggle = () => {
    setShowDropdown((prev) => !prev);
    setRotate((prev) => !prev);
  };

  const handleBlur = () => {
    setTimeout(() => {
      setShowDropdown(false);
      setRotate(false);
    }, 150);
  };

  const handleSelectMonth = (month: string) => {
    setSelectedMonth(month);
    dispatch(updateAddPostData({ published_month: month }));
    setShowDropdown(false);
    setRotate(false);
  };

  return (
    <div className="w-full flex flex-col relative h-full">
    
      <label htmlFor="close-time" className="font-poppins text-sm font-medium text-textcolor">
        Month <span className="text-[#F21818] pl-[1px]">*</span>
      </label>


      <div className="relative mt-1 flex items-center cursor-pointer">
        <input
          type="text"
          id="month"
          readOnly
          value={selectedMonth}
          placeholder="Select month"
          className="w-full rounded-lg border border-bordercolor cursor-pointer focus:border-blue-500 text-textcolor bg-primary px-4 py-2.5 my-1 placeholder:text-placeholdercolor placeholder:text-sm focus:outline-none"
          onClick={handleToggle}
          onBlur={handleBlur}
        />
        <div
          className={`absolute right-2 text-xl cursor-pointer transition-transform ${rotate ? "rotate-90" : "-rotate-90"}`}
          onClick={handleToggle}
        >
          <MdOutlineChevronRight />
        </div>
      </div>

      {showDropdown && (
        <ul className="absolute top-[5rem] left-0 w-full bg-white text-textcolor rounded-lg shadow-lg max-h-[200px] overflow-y-auto z-10 border border-bordercolor mt-1">
          {months.map((month) => (
            <li
              key={month}
              className="px-4 py-2 font-poppins text-sm hover:bg-gray-100 cursor-pointer"
              onMouseDown={() => handleSelectMonth(month)}
            >
              {month}
            </li>
          ))}
        </ul>
      )}
    </div>
  );
}

export default MonthDropdown;
