"use client";
import { useDispatch } from "react-redux";
import { useEffect, useState } from "react";
import { MdOutlineCheck, MdOutlineChevronRight } from "react-icons/md";
import { useAppSelector } from "../../../Hooks/Hooks";
import { removeDay, setSelectedDays, toggleDaySelection } from "../../../Appstore/Slice/Storevalues/OpenDaySlice";


const weekDays = [
  "Monday", "Tuesday", "Wednesday",
  "Thursday", "Friday", "Saturday", "Sunday"
];

const OpenDay = () => {
  const dispatch = useDispatch();

  //   if opne day values exit warring only for update contion to show  pre filed values


  const openDay = useAppSelector((state) => state.service.service?.open_days)

  console.log("my open day values", openDay)

  const selectedDays = useAppSelector((state) => state.openDay.selectedDays);


  useEffect(() => {
    if (openDay && selectedDays.length === 0) {
      const normalized = openDay.split(",").map((day: string) => {
        const trimmed = day.trim().toLowerCase();
        const full = weekDays.find((d) => d.toLowerCase().startsWith(trimmed));
        return full;
      }).filter(Boolean) as string[];

      dispatch(setSelectedDays(normalized));
    }
  }, [openDay, dispatch, selectedDays.length]);



  console.log("selectedDaysselectedDaysselectedDays", selectedDays)

  const [searchValue, setSearchValue] = useState("");
  const [showDropdown, setShowDropdown] = useState(false);
  const [rotate, setRotate] = useState(false);

  const handleToggleDropdown = () => {
    setShowDropdown((prev) => !prev);
    setRotate((prev) => !prev);
  };

  const handleSelectDay = (day: string) => {
    dispatch(toggleDaySelection(day));
  };

  const handleRemove = (day: string) => {
    dispatch(removeDay(day));
  };

  const handleFocus = () => {
    setShowDropdown(true);
    setRotate(true);
  };

  const handleBlur = () => {
    setTimeout(() => {
      setShowDropdown(false);
      setRotate(false);
    }, 150);
  };

  const filteredDays = weekDays.filter((day) =>
    day.toLowerCase().includes(searchValue.toLowerCase())
  );

  return (
    <div className="w-full flex flex-col relative h-full">
      <label className="font-poppins text-sm font-medium text-textcolor">
        Open Days<span className="text-[#F21818] pl-[1px]">*</span>
      </label>

      <div className="relative mt-1 flex items-center cursor-pointer">
        <input
          type="text"
          placeholder="Search or select day"
          className="w-full rounded-lg border border-bordercolor focus:border-blue-500 text-textcolor bg-primary px-4 py-2.5 my-1 placeholder:text-placeholdercolor placeholder:text-sm focus:outline-none"
          value={searchValue}
          onChange={(e) => setSearchValue(e.target.value)}
          onFocus={handleFocus}
          onBlur={handleBlur}
        />
        <div
          className={`absolute right-2 text-xl transition-transform ${rotate ? "rotate-90" : "-rotate-90"}`}
          onClick={handleToggleDropdown}
        >
          <MdOutlineChevronRight />
        </div>
      </div>

      {selectedDays.length > 0 && (
        <div className="flex flex-wrap mt-2 gap-2">
          {selectedDays.map((day) => (
            <span
              key={day}
              className="flex items-center bg-[#1c5bb9c4] text-white px-3 py-1 rounded-full text-sm font-poppins"
            >
              {day}
              <button
                className="ml-2 text-red-500 hover:text-red-700"
                onClick={() => handleRemove(day)}
              >
                ×
              </button>
            </span>
          ))}
        </div>
      )}

      {showDropdown && (
        <ul className="absolute top-[5rem] left-0 w-full bg-white text-textcolor rounded-lg shadow-lg max-h-[200px] overflow-y-auto z-10 border border-bordercolor mt-1">
          {filteredDays.length > 0 ? (
            filteredDays.map((day) => (
              <li
                key={day}
                className="px-4 py-2 cursor-pointer font-poppins hover:bg-gray-100 flex justify-between items-center"
                onMouseDown={() => handleSelectDay(day)}
              >
                {day}
                {selectedDays.includes(day) && (
                  <MdOutlineCheck className="text-[#6565657a] text-lg" />
                )}
              </li>
            ))
          ) : (
            <li className="px-4 py-2 font-poppins text-center text-gray-500">No days found</li>
          )}
        </ul>
      )}
    </div>
  );
};

export default OpenDay;
