import React from "react";
import PhoneInput from "react-phone-input-2";
import "react-phone-input-2/lib/high-res.css";
import "./PhoneStyle.css";
import { useAppDispatch, useAppSelector } from "../../../Hooks/Hooks";
import { updateAddPostData } from "../../../Appstore/Slice/Storevalues/AddStoreSlice";

function PhoneNumber() {
    const dispatch = useAppDispatch();
    const { service_phone, service_country_code } = useAppSelector((state) => state.AddStoreSlice);



    console.log(" my service number " ,service_country_code, service_phone )

    const handlePhoneChange = (value: string, data: any) => {
        // Extract country code and national number
        const countryCode = data.dialCode;
        const nationalNumber = value.replace(countryCode, "");

        // Dispatch to Redux
        dispatch(
            updateAddPostData({
                service_country_code: `+${countryCode}`,
                service_phone: nationalNumber,
            })
        );

        console.log("Full:", value);
        console.log("Country Code:", `+${countryCode}`);
        console.log("National Number:", nationalNumber);
    };

    return (
        <div className="w-full flex flex-col gap-2">
            <label className="font-poppins text-sm font-medium text-[#000000]" htmlFor="mobile">
                Phone number
                <span className="text-[#F21818] pl-[1px]">*</span>
            </label>

            <div className="relative w-full">
                <PhoneInput
                    country={"in"}
                    value={`${service_country_code?.replace("+", "")}${service_phone}`}
                    onChange={handlePhoneChange}
                    placeholder="Enter phone number"
                    enableSearch
                />
            </div>
        </div>
    );
}

export default PhoneNumber;
