import React from 'react'
import StoreImage from './StoreImage'
import StoreCoverImage from './StoreCoverImage'
import { useAppDispatch, useAppSelector } from '../../../Hooks/Hooks';
import { updateAddPostData } from '../../../Appstore/Slice/Storevalues/AddStoreSlice';
import FormGlobalInputAnalytical from '../../../Componets/Form/FormGlobalINputNlytical';
import toast from 'react-hot-toast';

function Media() {

  const dispatch = useAppDispatch()

  const formData = useAppSelector((state) => state.AddStoreSlice);
  const handleChange = (e: React.ChangeEvent<HTMLInputElement | HTMLTextAreaElement>) => {
    const { name, value } = e.target;
    dispatch(updateAddPostData({ [name]: value }));
  };


  const coverImage = useAppSelector((state) => state.UploadServiceAttactmentSlice.cover_image);
  const StoreImage12 = useAppSelector((state) => state.UploadAddserviceImageSlice.cover_images);


  const handleNextStep = () => {

    if (!coverImage || StoreImage12.length == 0) {
      toast.error("All filed are required !")
      return;
    }

    // Increment add_new_post_steps by 1
    if ((formData.add_new_post_steps ?? 0) < 5) {
      dispatch(
        updateAddPostData({
          add_new_post_steps: ((formData.add_new_post_steps ?? 0) + 1) as
            | 1
            | 2
            | 3,
        })
      );
    }
  };



  const handlePreviousStep = () => {
    // Decrement add_new_post_steps by 1
    if ((formData.add_new_post_steps ?? 0) > 1) {
      dispatch(
        updateAddPostData({
          add_new_post_steps: ((formData.add_new_post_steps ?? 0) - 1) as
            | 1
            | 2
            | 3,
        })
      );
    }
  };

  return (
     <div className="w-full flex flex-col mt-4 md:mt-0 p-6 border border-bordercolor rounded-lg gap-6">
      <div className="w-full h-fit grid md:grid-cols-2 gap-4">
        <StoreCoverImage />
        <StoreImage />
      </div>

      <div className=' w-full '>
        <FormGlobalInputAnalytical label="Video URL " name="video_url" value={formData.video_url || ""} onChange={handleChange}  placeholder="Enter  Video url" />
      </div>


      {/*  previous and next btn  */}

      <div className=" w-full  flex justify-center   gap-9 items-center">

        {/*  previous btn */}

        <button className="w-fit px-[3rem] py-2 bggradient rounded-lg cursor-pointer font-poppins text-white" onClick={handlePreviousStep} >Previous</button>
        <button className="w-fit px-[3rem] py-2 bggradient rounded-lg cursor-pointer font-poppins text-white" onClick={handleNextStep} >Next</button>


      </div>

    </div>
  )
}

export default Media
