import React from 'react';
import PhoneInput from 'react-phone-input-2';
import 'react-phone-input-2/lib/high-res.css';
import { useDispatch } from 'react-redux';
import { setPhoneNumber } from '../../Appstore/Slice/AddVendorSlice';
import { useAppSelector } from '../../Hooks/Hooks';

function PhoneNumberAddVendor() {
    const dispatch = useDispatch();

    const handlePhoneChange = (value: string, data: any) => {
        const countryDialCode = data.dialCode; // e.g. '91'
        const nationalNumber = value.replace(countryDialCode, ""); // e.g. '9876543210'

        dispatch(setPhoneNumber({
            fullPhoneNumber: `+${value}`, // e.g. +919876543210
            countryCode: `+${countryDialCode}`, // e.g. +91
            nationalNumber: nationalNumber, // e.g. 9876543210
        }));

        console.log("Full:", value);
        console.log("Country Code:", `+${countryDialCode}`);
        console.log("National Number:", nationalNumber);
    };

    const phoneData = useAppSelector((state) => state.addVendor);
    console.log("Redux Store Phone Data", phoneData.fullPhoneNumber);

    return (
        <div className="w-full flex flex-col gap-2">
            <label
                className="font-poppins text-sm font-medium text-textcolor "
                htmlFor="mobile"
            >
                Phone number
                <span className="text-[#F21818] pl-[1px]">*</span>
            </label>

            <div className="relative w-full bg-primary">
                <PhoneInput
                    country={'in'}
                    value={phoneData.fullPhoneNumber?.replace("+", "")}
                    onChange={handlePhoneChange}
                    placeholder="Enter phone number"
                    enableSearch
                    inputClass="!w-full"
                />
            </div>
        </div>
    );
}

export default PhoneNumberAddVendor;
