import React, { useEffect, useState } from "react";
import useApiPost from "../../Hooks/PostData";
import { useAppDispatch } from "../../Hooks/Hooks";
import { setUsername, setUsernameAvailability } from "../../Appstore/Slice/AddVendorSlice";

function UserNameCheck() {
    const { loading, postData } = useApiPost();
    const [username, setLocalUsername] = useState("");
    const [isAvailable, setIsAvailable] = useState<null | boolean>(null);
    const [message, setMessage] = useState("");
    const [debouncedUsername, setDebouncedUsername] = useState("");

    const dispatch = useAppDispatch();

    // Debounce logic
    useEffect(() => {
        const handler = setTimeout(() => {
            setDebouncedUsername(username);
        }, 500);
        return () => clearTimeout(handler);
    }, [username]);

    // API call and dispatch state
    useEffect(() => {
        const checkUsername = async () => {
            if (!debouncedUsername) {
                setIsAvailable(null);
                setMessage("");
                dispatch(setUsername(""));
                dispatch(setUsernameAvailability(null));
                return;
            }

            const formData = new FormData();
            formData.append("username", debouncedUsername);

            const response = await postData("/username-exist", formData);

            if (response?.status === false) {
                setIsAvailable(false);
                setMessage("Username already exists.");
                dispatch(setUsernameAvailability(false));
            } else {
                setIsAvailable(true);
                setMessage("Username is available.");
                dispatch(setUsername(debouncedUsername));
                dispatch(setUsernameAvailability(true));
            }
        };

        checkUsername();
    }, [debouncedUsername, dispatch]);

    const getBorderColor = () => {
        if (isAvailable === null) return "border-bordercolor";
        return isAvailable ? "border-green-500" : "border-red-500";
    };

    const getTextColor = () => {
        return isAvailable ? "text-green-500" : "text-red-500";
    };

    return (
        <div className="flex flex-col gap-1">
            <label className="font-poppins text-sm font-normal text-textcolor">
                User Name<span className="text-[#F21818] pl-[1px]">*</span>
            </label>

            <div className="relative w-full">
                <input
                    type="text"
                    value={username}
                    onChange={(e) => {
                        setLocalUsername(e.target.value);
                        setIsAvailable(null);
                        setMessage("");
                    }}
                    placeholder="Enter User Name"
                    className={`w-full pr-10 rounded-lg border ${getBorderColor()} font-normal  text-textcolor bg-primary px-4 py-2.5 my-1 placeholder:text-placeholdercolor placeholder:text-sm focus:outline-none`}
                />

                {loading && (
                    <div className="absolute top-1/2 right-3 -translate-y-1/2">
                        <svg
                            className="animate-spin h-5 w-5 text-gray-600"
                            xmlns="http://www.w3.org/2000/svg"
                            fill="none"
                            viewBox="0 0 24 24"
                        >
                            <circle
                                className="opacity-25"
                                cx="12"
                                cy="12"
                                r="10"
                                stroke="currentColor"
                                strokeWidth="4"
                            />
                            <path
                                className="opacity-75"
                                fill="currentColor"
                                d="M4 12a8 8 0 018-8v4a4 4 0 00-4 4H4z"
                            />
                        </svg>
                    </div>
                )}
            </div>

            {message && (
                <span className={`text-sm font-medium ${getTextColor()}`}>
                    {message}
                </span>
            )}
        </div>
    );
}

export default UserNameCheck;
