import { useEffect, useState } from "react";
import { UsegetAdminDetail } from "../../Appstore/Api/Admin_profile/UsegetAdminDetail";
import Name from "../../assets/Images/name.png";
import email from "../../assets/Images/email.png";
import Mobile from "../../assets/Images/mobile.png";
import Plus from "../../assets/Images/Plus.png";
import NameInputBox from "../../Componets/Form/NameInputBox";
import useApiPost from "../../Hooks/PostData";
import toast from "react-hot-toast";
import { useAppDispatch } from "../../Hooks/Hooks";
import { setAdminData } from "../../Appstore/Slice/AdminDetail";
import "react-datepicker/dist/react-datepicker.css";
import { IoCallOutline } from "react-icons/io5";

function EditProfile() {
    const [startDate, setStartDate] = useState<Date | null>(null);

    const [formData, setFormData] = useState({
        profile_pic: "",
        first_name: "",
        last_name: "",
        email: "",
        mobile: "",

    });

    const { data, isLoading, isError } = UsegetAdminDetail(); // Assuming this is a custom hook for fetching admin details
    const admin_detail = data?.admindetails;

    const { postData, loading, error } = useApiPost(); // Assuming this is a custom hook for making API requests

    const [selectedProfilePic, setSelectedProfilePic] = useState<File | null>(null);

    const dispatch = useAppDispatch();

    // Populate data on mount
    useEffect(() => {
        if (admin_detail) {
            setFormData({
                profile_pic: admin_detail.image || "",
                first_name: admin_detail.first_name || "",
                last_name: admin_detail.last_name || "",
                email: admin_detail.email || "",
                mobile: admin_detail.mobile || "",
            });
            dispatch(setAdminData(admin_detail)); // Update the Redux store with new data


            // Set the start date for DatePicker
            if (admin_detail.dob) {
                setStartDate(new Date(admin_detail.dob));
            }

            dispatch(setAdminData(admin_detail)); // Dispatch admin data for state management
        }
    }, [admin_detail, dispatch]);

    // Handle input change
    const handleChange = (field: string, value: string) => {
        setFormData((prev) => ({
            ...prev,
            [field]: value,
        }));
    };

    // Handle profile pict593A99ure change
    const handleProfilePicChange = (e: React.ChangeEvent<HTMLInputElement>) => {
        const file = e.target.files?.[0];
        if (!file) return;

        setSelectedProfilePic(file);

        const previewUrl = URL.createObjectURL(file);
        setFormData((prev) => ({ ...prev, profile_pic: previewUrl }));
    };


        const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';



    const handleEditProfile = async () => {
           if (IS_DEMO) {
            toast.error("This action is disabled in the demo version.");
            return;
        }
        try {
            const formDataToUpload = new FormData();
            formDataToUpload.append("first_name", formData.first_name);
            formDataToUpload.append("last_name", formData.last_name);
            formDataToUpload.append("email", formData.email);
            formDataToUpload.append("mobile", formData.mobile);

            if (selectedProfilePic) {
                formDataToUpload.append("image", selectedProfilePic);
            }
            formDataToUpload.append("user_id", "1");

            const response = await postData("/update-adminprofile", formDataToUpload, "multipart/form-data");
            const updatedAdminData = response?.admindetails;

            console.log("updatedAdminData deail api", updatedAdminData);

            // Map API response to AdminState shape
            dispatch(setAdminData({
                admin_id: updatedAdminData.id || null,
                first_name: updatedAdminData.first_name || '',
                last_name: updatedAdminData.last_name || '',
                full_name: `${updatedAdminData.first_name || ''} ${updatedAdminData.last_name || ''}`.trim(),
                email: updatedAdminData.email || '',
                mobile_number: updatedAdminData.mobile || '',
                profile_pic: updatedAdminData.image || '',
                country: updatedAdminData.country || '',
                gender: updatedAdminData.gender || '',
                dob: updatedAdminData.dob || '',
                country_short_name: updatedAdminData.country_short_name || '',
            }));

            toast.success("Profile updated successfully!");
        } catch (error) {
            toast.error("Something went wrong while updating the profile.");
        }
    };

    return (
        <div className="flex justify-center">
            <div className="max-w-[1000px] w-full">
                {/* Profile image */}
                <div className="flex items-center justify-center w-full py-4 ">
                    <div className="shadow-[9.3px_10.46px_64.96px_0px_rgba(0,0,0,0.2)] px-1 py-1   cursor-pointer  rounded-full" onClick={() => document.getElementById("profilePicInput")?.click()}>
                        <div className="relative flex items-center justify-center w-28 h-28">
                            <img src={formData.profile_pic} alt="User" className="absolute inset-0 m-auto rounded-full w-28 h-28 object-cover" />
                            <img src={Plus} alt="plus" className="absolute bottom-0 right-0 cursor-pointer w-7 h-7" />
                            <input type="file" accept="image/*" id="profilePicInput" className="hidden" onChange={handleProfilePicChange} />
                        </div>
                    </div>
                </div>

                {/* Display name */}
                <h2 className="flex justify-center pb-3 text-base font-semibold font-poppins  text-textcolor">{`${admin_detail?.first_name} ${admin_detail?.last_name}` || "Your Name"}</h2>

                {/* Input fields */}
                <div className="grid gap-3 px-4 md:gap-10 md:py-4 md:grid-cols-2">
                    <NameInputBox label="First Name" iconSrc={Name} placeholder="Enter First Name" required value={formData.first_name} onChange={(value) => handleChange("first_name", value)} name="first_name" />

                    <NameInputBox label="Last Name" iconSrc={Name} placeholder="Enter Last Name" required value={formData.last_name} onChange={(value) => handleChange("last_name", value)} name="last_name" />

                    <NameInputBox label="Email" iconSrc={email} placeholder="Enter  Email" required value={formData.email} onChange={(value) => handleChange("email", value)} name="email" />

                    {/*  mobail number */}
                    <div className="relative flex flex-col">
                        <label className="text-textcolor font-poppins text-sm ">
                            Mobile Number<span className="text-sm text-red-600">*</span>
                        </label>
                        <div className="relative">
                            <div className="absolute flex items-center justify-center p-3 transform -translate-y-1/2 rounded-lg active_btn_profile  left-2 top-1/2">
                                <IoCallOutline className="w-5 h-5 text-[#0046ae]" />
                            </div>
                            <input
                                type="tel"
                                className="border placeholder:text-textcolor border-bordercolor rounded-lg w-full py-4 my-1 pl-16 placeholder:font-poppins placeholder:text-sm placeholder:opacity-50  text-textcolor focus:outline-none focus:ring-1 focus:ring-[#0046AE]"
                                placeholder="Enter Mobile Number"
                                required
                                autoComplete="off"
                                autoCorrect="off"
                                spellCheck="false"
                                value={formData.mobile}
                                onChange={(e) => handleChange("mobile", e.target.value)}
                            />
                        </div>
                    </div>

                </div>

                {/* Submit Button */}
                <div className="flex justify-center py-8">
                    <button
                        onClick={handleEditProfile}
                        disabled={loading}
                        className={`text-base font-poppins text-white px-16 py-2 rounded-lg bggradient transition-opacity duration-300 ${loading ? "opacity-50 cursor-not-allowed" : "cursor-pointer"}`}
                    >
                        {loading ? "Updating..." : "Submit"}
                    </button>
                </div>
            </div>
        </div>
    );
}

export default EditProfile;
