import React, { useEffect, useState } from 'react';
import toast from 'react-hot-toast';
import JoditEditor from 'jodit-react';
import { useAppDispatch } from '../../Hooks/Hooks';
import Apimethod from '../../Hooks/Apimethod';
import { useSelector } from 'react-redux';
import { Link } from 'react-router-dom';
import SearchBar from '../../Componets/SearchBar/SearchBar';
import { useGetDataWithToken } from '../../Appstore/Api/UsegetRefundpolicy';

const editorConfig = {
    readonly: false,
    height: 520,
    toolbarAdaptive: false,
    placeholder: ' ',
    spellcheck: true,
    showCharsCounter: false,
    showWordsCounter: false,
    toolbar: true,
    askBeforePasteHTML: false,
    cleanHTML: {
        removeStyles: true,
        removeTags: ['style', 'script'],
    },
};

function Contact(): JSX.Element {
    const isSidebarOpen = useSelector((state: any) => state.sidebar.isOpen);

    const { data, isLoading, error, refetch } = useGetDataWithToken("/contact-us", ["contact-us"]);



    console.log("datadatamonu yadavb", data?.data?.text)




    const [DeleteAccountCms, setDeleteAccountCms] = useState<string>("");
    const { loading, makeRequest } = Apimethod();



    //  when page load then values send in state in payload 

    useEffect(() => {
        if (data?.data?.text) {
            setDeleteAccountCms(data?.data?.text || "")
        }
    }, [data])


    const dispatch = useAppDispatch()

        const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';


    const handleAddPolicy = async () => {

          if (IS_DEMO) {
            toast.error("This action is disabled in the demo version.");
            return;
        }
        const formData = new FormData();
        formData.append('text', DeleteAccountCms ?? "");

        try {
            const res = await makeRequest('/contact-us', formData, 'multipart/form-data', 'POST');
            toast.success('Contact-us Policy Updated Successfully!');
            refetch()

        } catch (error) {
            toast.error('Failed to update policy');
        }
    };

    return (
        <div className={`bg-primary ${isSidebarOpen ? "xl:pl-20" : "xl:pl-72"}`}>
            <SearchBar />
            <div className="px-4 pb-10 xl:px-6">
                <div className="flex justify-between border-t-bordercolor py-3">
                    <h2 className="text-textcolor font-poppins text-xl font-semibold pt-3 ">Contact Us</h2>

                </div>

                <div className="flex items-center justify-between">
                    <div className="flex items-center gap-2">
                        <Link to="/dashboard">
                            <h3 className="text-[#3A3A3A] font-poppins text-base  font-semibold">Dashboard</h3>
                        </Link>
                        <div className="rounded-full w-1 h-1 bg-[#E0E0E0]"></div>
                        <h3 className="text-[#858585] font-poppins text-base">Contact Us</h3>
                    </div>

                </div>
                <div className="p-3 space-y-5 md:p-6">
                    <form className="space-y-6" onSubmit={(e) => e.preventDefault()}>
                        <div>
                            <div className="p-4 bg-white border-[#E3E3E3] rounded shadow h-[550px]">
                                <JoditEditor
                                    value={DeleteAccountCms}
                                    config={editorConfig}
                                    onChange={(newContent: string) => setDeleteAccountCms(newContent)}
                                />
                            </div>
                        </div>
                    </form>

                    <button
                        type="button"
                        className="flex gap-1.5 items-center cursor-pointer px-6 py-2 bggradient rounded-lg font-poppins font-medium text-white"
                        onClick={handleAddPolicy}
                        disabled={loading}
                    >
                        {loading ? 'Submitting...' : 'Submit'}
                    </button>
                </div>
            </div>
        </div>

    );
}

export default Contact;
