import React, { useEffect, useState } from 'react'
import { useSelector } from 'react-redux';
import { Link } from 'react-router-dom';
import SearchBar from '../../Componets/SearchBar/SearchBar'
import Search from "../../assets/Images/search.png"
import WithoutSorttableHeader from '../../Componets/TableComponets/WithoutSorttableHeader';
import { useAppDispatch, useAppSelector } from '../../Hooks/Hooks';
import useApiPost from '../../Hooks/PostData';
import { showModal } from '../../Appstore/Slice/ModalSlice';
import { reset } from '../../Appstore/Slice/toggleSlice';
import CustomerSupportPagination from '../../Componets/PaginationComponets/CustomerSupportPagination';
import { setCustomerSupportPaginationSlice } from '../../Appstore/Slice/PaginationSlice/CustomerSupportPaginationSlice';
import AvatarWithSpinner from '../../Componets/LoadingComponest';
import TableDateTimeDisplay from '../../Componets/TableComponets/TableDateTimeDisplay';
import SimpletextTableBodyReview from '../../Componets/TableComponets/SimpletextTableBodyReview';
import TableActionButtons from '../../Componets/TableComponets/TableActionButtons';
import Block from "../../assets/Images/deleteicon.png"
import notfound from "../../assets/Images/notfound.png"
import SimpletextTableBody from '../../Componets/TableComponets/SimpletextTableBody';
import toast from 'react-hot-toast';

function CustomerSupport() {
  const isSidebarOpen = useSelector((state: any) => state.sidebar.isOpen);
  const { data, loading, error, postData } = useApiPost();
  const [search, setSearch] = useState("")
  const pagination = useAppSelector((state) => state.CustomerSupportPaginationSlice);
  const { current_page, records_per_page } = pagination;


  const [toggleStates, setToggleStates] = useState<{ [key: number]: boolean }>({});

  // Fetch data
  useEffect(() => {
    const params = {
      page: current_page,
      pageSize: records_per_page,
      search: search.trim()
    };

    postData("/customer-support", params);
  }, [current_page, records_per_page, search]);



  const isaddgiftvalues = useAppSelector((state) => state.toggle.value)


  useEffect(() => {

    if (isaddgiftvalues) {
      postData("/customer-support", {});
    }

  }, [isaddgiftvalues])




  useEffect(() => {
    if (data?.data) {
      const toggles = data.data.reduce((acc, gift) => {
        acc[gift.id] = gift.status;
        return acc;
      }, {} as { [key: number]: boolean });
      setToggleStates(toggles);
    }
  }, [data]);



  const dispatch = useAppDispatch()


  useEffect(() => {
    if (data?.Pagination) {
      dispatch(setCustomerSupportPaginationSlice(data?.Pagination));
    }
  }, [data, dispatch]);


    const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';





  const handleBlock = (id: string) => {

    sessionStorage.setItem("customersupport-id", id)
    dispatch(showModal("DeleteCustomerSuportModal"))
    dispatch(reset())
  }


  return (
    <div className={`bg-primary ${isSidebarOpen ? 'xl:pl-20' : 'xl:pl-72'}`}>
      <SearchBar />

      <div className="px-4 pb-10 xl:px-6">
        {/* Header */}
        <div className="flex justify-between border-t-[#F2F2F2] py-3">
          <h2 className="text-textcolor font-poppins text-xl font-semibold pt-3 ">
            Customer Support
          </h2>
          <div className="relative">
            <div className="absolute left-2  top-5 md:top-1/2 flex transform -translate-y-1/2 items-center p-2">
              <img src={Search} alt="Search" className="h-4 w-4 md:h-5 md:w-5" />
            </div>
            <div className=' w-full'>
              <input
                type="text"
                placeholder="Search by name..."
                className="w-[180px] md:w-[250px] pl-10 py-2 text-sm placeholder:text-placeholdercolor
              border border-bordercolor border-opacity-10 rounded-lg bg-[#00000005] 
              focus:outline-none focus:ring-1 focus:ring-gray-600 
              placeholder:dark:text-tableDarkLarge "

                onChange={(e) => setSearch(e.target.value)}
                value={search}
              />
            </div>
          </div>
        </div>

        {/* Breadcrumb */}
        <div className="mb-4 flex w-full  justify-between items-center gap-2">
          <div className=' flex gap-3 items-center'>
            <Link to="/dashboard">
              <h3 className="text-base font-semibold text-[#3A3A3A]  font-poppins">Dashboard</h3>
            </Link>
            <div className="h-1 w-1 rounded-full bg-[#E0E0E0]"></div>
            <h3 className="text-base text-[#858585] font-poppins">Customer Support</h3>
          </div>
        </div>
        <div className="relative border border-bordercolor rounded-lg mt-8 mx-4 sm:mx-0 overflow-x-auto w-full">

          <div className="min-w-[1200px]">
            <div className="flex px-4 py-3   rounded-t-lg text-left border-b w-full bg-headercolortable border-b-bordercolor sm:pl-8">
              <div className="w-[6%]">
                <WithoutSorttableHeader label="S.L" />
              </div>
              <div className="w-[13%]">
                <WithoutSorttableHeader label="NAME" />
              </div>
              <div className="w-[18%]">
                <WithoutSorttableHeader label="EMAIL" />
              </div>
              <div className="w-[16%]">
                <WithoutSorttableHeader label="PHONE" />
              </div>
              <div className="w-[20%]">
                <WithoutSorttableHeader label="MESSAGE" />
              </div>
              <div className="w-[17%]">
                <WithoutSorttableHeader label="CREATED DATE/TIME" />
              </div>
              <div className="w-[10%]">
                <WithoutSorttableHeader label="ACTIONS" />
              </div>

            </div>
          </div>

          <div className="relative">

            {loading && (

              <div className=" h-[400px] flex items-center justify-center  ">

                <AvatarWithSpinner />

              </div>

            )}



            {!loading && data?.customers?.length > 0 ? (

              data.customers.map((gift: any, index: number) => (

                <div key={gift.gift_id} className={`   min-w-[1200px] flex gap-4   ${index % 2 === 0 ? 'bg-white dark:bg-primary' : 'bg-[#00162e0a] dark:bg-primary'

                  } flex items-center px-4 py-3 border-b border-b-bordercolor sm:pl-8`}>

                  <div className="w-[6%] text-sm text-textcolor font-poppins">

                    {(current_page - 1) * records_per_page + index + 1}

                  </div>


                  <div className=' w-[13%]'>
                    <SimpletextTableBody title={gift.name} />
                  </div>
                  <div className=' w-[18%]'>
                    <SimpletextTableBody title={gift.email} />
                  </div>
                  <div className=' w-[16%] '>
                    <SimpletextTableBody title={gift.phone} />
                  </div>


                  <div className="w-[20%] whitespace-pre-wrap break-words text-textcolor">
                    <SimpletextTableBodyReview title={gift.message} />
                  </div>

                  <div className=' w-[17%]'>
                    <TableDateTimeDisplay dateString={gift.created_at} />

                  </div>




                  <div className=' w-[10%]   pl-5 flex gap-3'>

                    <TableActionButtons
                      viewButtonColor="#CCE1CD"

                      borderColor="#01D312"

                      blockButtonIcon={Block}

                      onBlockClick={() => handleBlock(gift.id)}

                    />
                  </div>





                </div>

              ))

            ) : !loading &&



            <div className="p-4 h-[38rem] flex justify-center items-center">

              <div className="w-full flex flex-col items-center h-full justify-center">

                <img

                  src={notfound}

                  alt="Not Found"

                  className="w-1/2 max-h-[40vh] object-contain"

                />

                <h2 className="font-poppins text-lg text-textcolor  mt-4">

                  No  Data Found

                </h2>

              </div>

            </div>



            }

          </div>




          <CustomerSupportPagination />
        </div>
      </div>


    </div>
  )
}

export default CustomerSupport
