import { Link, useNavigate } from 'react-router-dom';
import WithoutSorttableHeader from '../../Componets/TableComponets/WithoutSorttableHeader';
import TableUserInfo from '../../Componets/TableComponets/TableUserInfo';

import { UsegetDashboardData } from '../../Appstore/Api/UsegetDashboardData';
import notfound from "../../assets/Images/notfound.png"
import AvatarWithSpinner from '../../Componets/LoadingComponest';
import { IoStar } from 'react-icons/io5';
import SimpletextTableBody from '../../Componets/TableComponets/SimpletextTableBody';
function DashboardUserList() {


  //  get store detail in dasboard

  const { data, isLoading } = UsegetDashboardData()












  const handalview = (id: string) => {
        sessionStorage.setItem("storIDViews", id)
        navigate(`/store-list/view-store`);
    }



    const navigate = useNavigate();

   const handleOpenStory = (user: any) => {
        console.log("my all user detail@111", user?.id);
        navigate("/View-Vendor");
        sessionStorage.setItem("user_id", user?.id)


    };




  return (
    <div className="border    border-bordercolor rounded-lg overflow-x-auto  w-full  xl:w-[65%] h-fit">
      <div className="min-w-[1010px]">
        <div className="py-5">
          {/* Header */}
          <div className="flex items-center justify-between px-4 mb-4">
            <h2 className="text-textcolor font-poppins text-base font-semibold ">
              Recent Stores
            </h2>
            <Link to="/store-list">
              <p className="cursor-pointer text-[#484848] text-sm underline font-poppins">View All</p>

            </Link>
          </div>

          {/* Table */}
          <div className="border border-bordercolor rounded-lg overflow-x-auto mx-4">
            {/* Table Header */}
            <div className="flex items-center px-4 py-4 text-left border-b bg-headercolortable border-b-bordercolor sm:pl-8 gap-4">

              <div className="w-[40%]">
                <WithoutSorttableHeader label="STORE" />
              </div>
              <div className="w-[35%]">
                <WithoutSorttableHeader label="VENDOR" />
              </div>
              <div className="w-[15%]">
                <WithoutSorttableHeader label="CATEGORY" />
              </div>
              <div className="w-[10%]">
                <WithoutSorttableHeader label="PRICE" />
              </div>

            </div>

            <div className="relative">
              {isLoading ? (
                <div className="h-[400px] flex items-center justify-center">
                  <AvatarWithSpinner />
                </div>
              ) : data?.data?.recentServices?.length > 0 ? (
                data?.data?.recentServices.map((gift: any, index: number) => (
                  <div key={gift.gift_id} className={`flex items-center px-4 py-3 border-b border-bordercolor sm:pl-8 ${index % 2 === 0 ? "bg-white dark:bg-primary" : "bg-[#00162e0a] dark:bg-primary"}`}>
                    {/* S.L */}

                    {/* Store */}
                    <div className="w-[40%] flex gap-3 items-center cursor-pointer" onClick={() => handalview(gift.id)} >
                      <div className="w-10 h-10 rounded-full overflow-hidden">
                        <img src={gift?.service_images[0]?.service_images} alt="Service" className="w-full h-full object-cover" />
                      </div>
                      <div className="flex flex-col">
                        <div className="flex items-center gap-2">
                          <h4 className="text-[#0046AE] text-sm font-poppins">{gift.service_name}</h4>
                          <div className="flex items-center gap-1">
                            <IoStar className="text-yellow-400" />
                            <p className="text-gray-400 text-sm font-poppins">{gift.avg_review}</p>
                          </div>
                        </div>
                        <p className="text-[#a4a9b4] font-poppins">Price: {gift.price_range}</p>
                      </div>
                    </div>

                    {/* Vendor */}
                    <div className="w-[35%]">
                      <TableUserInfo
                        profilePic={gift?.vendor?.profile_photo_url}
                        username={`${gift.vendor.first_name} ${gift.vendor.last_name}`}
                        email={gift.vendor.email || "N/A"}
                        mobile={gift.country_code ? `${gift.country_code} ${gift.mobile || ""}` : "N/A"}
                        onClick={() => handleOpenStory(gift.vendor)}
                      />
                    </div>

                    {/* Category */}
                    <div className="w-[15%]">
                      <SimpletextTableBody title={gift.category.category_name} />
                    </div>


                    {/* Price */}
                    <div className="w-[10%]">
                      <SimpletextTableBody title={gift.price_range} />
                    </div>



                  </div>
                ))
              ) : (
                <div className="p-4 h-[38rem] flex justify-center items-center">
                  <div className="w-full flex flex-col items-center h-full justify-center">
                    <img src={notfound} alt="Not Found" className="w-1/2 max-h-[40vh] object-contain" />
                    <h2 className="font-poppins text-lg text-textcolor mt-4">No  Data Found</h2>
                  </div>
                </div>
              )}
            </div>
          </div>
        </div>
      </div>
    </div>
  );
}

export default DashboardUserList;
