import { Link, useNavigate } from "react-router-dom";
import WithoutSorttableHeader from "../../Componets/TableComponets/WithoutSorttableHeader";
import { UsegetDashboardData } from "../../Appstore/Api/UsegetDashboardData";
import notfound from "../../assets/Images/notfound.png"
import EditIcon from "../../assets/Images/edit.png"
import AvatarWithSpinner from "../../Componets/LoadingComponest";
import TableUserInfo from "../../Componets/TableComponets/TableUserInfo";
import SimpletextTableBody from "../../Componets/TableComponets/SimpletextTableBody";
import { useAppDispatch } from "../../Hooks/Hooks";
import { resetStore } from "../../Appstore/Slice/storeSliceUpdate";
import { reset } from "../../Appstore/Slice/toggleSlice";
import { clearSelectedStoreid } from "../../Appstore/Slice/UpdateSelectedStoreIDSlice";
import { clearAllCoverImages } from "../../Appstore/Slice/UploadAddserviceImageSlice";
import { clearCoverImageatc } from "../../Appstore/Slice/UploadServiceAttactmentSlice";
import toast from "react-hot-toast";


function PostListDashborad() {



    const { data, isLoading } = UsegetDashboardData()



    const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';


    sessionStorage.setItem("defaultCurrency", data?.data?.defaultCurrency || "USD");


    const navigate = useNavigate();

    const dispatch = useAppDispatch()



    const handleNaviagteUpdate = (service: string) => {
        if (IS_DEMO) {
            toast.error("This action is disabled in the demo version.");
            return;
        }

        navigate(`/service-list/update-service`);
        dispatch(resetStore());
        dispatch(reset())
        dispatch(clearSelectedStoreid())
        dispatch(clearAllCoverImages())
        dispatch(clearCoverImageatc());
        sessionStorage.setItem("updateserviceid", service?.id);

    };



    const handleOpenStory = (user: any) => {
        console.log("my all user detail@111", user?.id);
        navigate("/View-Vendor");
        sessionStorage.setItem("user_id", user?.id)


    };





    const defaultCurrency = sessionStorage.getItem("defaultCurrency")

    return (
        <div className="border    border-bordercolor rounded-lg overflow-x-auto h-fit  w-full 2xl:w-[50%] xl:w-[100%]">
            <div className="xl:overflow-x-auto pb-4 lg:overflow-x-auto 2xl:overflow-hidden min-w-[1200px] md:min-w-[1200px] lg:min-w-[0px] sm:min-w-[0px]">
                <div className="min-w-max">
                    {/* Title and View All */}
                    <div className="flex items-center justify-between px-4 mt-4 mb-4">
                        <h2 className="text-textcolor font-poppins text-base font-semibold">Recent Services</h2>
                        <Link to="/service-list">
                            <p className="cursor-pointer text-[#484848] text-sm underline font-poppins">View All</p>
                        </Link>
                    </div>

                    {/* Table */}
                    <div className="border    border-bordercolor rounded-lg overflow-x-auto mx-4">
                        {/* Table Header */}
                        <div className="w-full flex items-center px-4 py-4 text-left border-b bg-headercolortable border-b-bordercolor sm:pl-8 gap-4">

                            <div className="w-[40%]">
                                <WithoutSorttableHeader label="SERVICE" />
                            </div>
                            <div className="w-[40%]">
                                <WithoutSorttableHeader label="STORE" />
                            </div>
                            <div className="w-[10%]">
                                <WithoutSorttableHeader label="PRICE" />
                            </div>

                            <div className="w-[10%]">
                                <WithoutSorttableHeader label="ACTION" />
                            </div>
                        </div>


                        <div className="relative">
                            {isLoading ? (
                                <div className="h-[400px] flex items-center justify-center">
                                    <AvatarWithSpinner />
                                </div>
                            ) : data?.data?.recentStores?.length > 0 ? (
                                data?.data?.recentStores?.map((gift: any, index: number) => (
                                    <div key={gift.gift_id} className={`flex items-center px-4 py-3 border-b border-bordercolor sm:pl-8 ${index % 2 === 0 ? "bg-white dark:bg-primary" : "bg-[#00162e0a] dark:bg-primary"}`}>
                                        {/* S.L */}


                                        {/* Store */}

                                        <div className="w-[40%] flex gap-3 items-center">
                                            <div className="w-10 h-10 rounded-full overflow-hidden">
                                                <img src={gift?.store_images[0]?.store_images} alt="Service" className="w-full h-full object-cover" />
                                            </div>

                                            <div className="flex flex-col">
                                                <div className="flex items-center gap-2">
                                                    <h4 className="text-[#0046AE] text-sm font-poppins">{gift.store_name}</h4>

                                                </div>

                                                <p className="text-[#a4a9b4] font-poppins">Price: {`${defaultCurrency}${gift.price}`}</p>
                                            </div>
                                        </div>

                                        {/* Vendor */}

                                        <div className="w-[40%]">
                                            <TableUserInfo
                                                profilePic={gift?.service?.vendor?.profile_photo_url}
                                                username={`${gift?.service?.vendor?.first_name}   ${gift?.service?.vendor?.last_name}`}
                                                email={gift?.service?.vendor.email || "N/A"}
                                                mobile={gift?.country_code ? `${gift?.country_code} ${gift?.mobile || ""}` : "N/A"}
                                                onClick={() => handleOpenStory(gift.service.vendor)}
                                            />
                                        </div>


                                        {/* Price */}

                                        <div className="w-[10%]">
                                            <SimpletextTableBody title={`${data?.data?.defaultCurrency} ${gift.price}`} />
                                        </div>

                                        {/* Date/Time */}


                                        {/* Actions */}

                                        <div className="w-[10%] flex items-center gap-3 justify-center">
                                            <button className="py-[9px] px-[10px] bg-[#D0CCE1]/60 rounded-full cursor-pointer  " onClick={() => handleNaviagteUpdate(gift)}>
                                                <img src={EditIcon} alt="Edit" className="w-4 h-4" />
                                            </button>

                                        </div>
                                    </div>
                                ))
                            ) : (
                                <div className="p-4 h-[38rem] flex justify-center items-center">
                                    <div className="w-full flex flex-col items-center h-full justify-center">
                                        <img src={notfound} alt="Not Found" className="w-1/2 max-h-[40vh] object-contain" />

                                        <h2 className="font-poppins text-lg text-textcolor mt-4">No  Data Found</h2>
                                    </div>
                                </div>
                            )}
                        </div>


                    </div>
                </div>
            </div>
        </div>
    );
}

export default PostListDashborad;
