import { useCallback, useEffect, useState } from "react";
import { useGetDataWithToken } from "../../../Appstore/Api/UsegetRefundpolicy";
import IMageBaner from "./IMageBaner";
import InputField from "../../../Componets/InputField";
import { useAppSelector } from "../../../Hooks/Hooks";
import useApiPost from "../../../Hooks/PostData";
import toast from "react-hot-toast";
import ToggleSwitchSettingLogin from "../../../Componets/ToggleSwitchSettingLogin";
import Apimethod from "../../../Hooks/Apimethod";



function SponsorStores() {

  const { data, isLoading, error, refetch } = useGetDataWithToken("/index-bannerupdate", ["index-bannerupdate"]);


      const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';


  console.log("datamonhu", data?.data?.image)
  sessionStorage.setItem("banerimage", data?.data?.image || "")
  const image = useAppSelector((state) => state.UpdateCategoryImageSlice.cover_image)



  const [formData, setFormData] = useState({
    play_store_url: "",
    app_store_url: "",
  });



  useEffect(() => {
    if (data?.data) {
      const { play_store_url, app_store_url } = data.data;
      const defaultForm = {
        play_store_url: play_store_url || "",
        app_store_url: app_store_url || "",

      };
      setFormData(defaultForm);
    }
  }, [data]);


  const handleChange = useCallback((field: string, value: string) => {
    setFormData((prev) => ({ ...prev, [field]: value }));
  }, []);


  const { postData, loading } = useApiPost()


  const handleSubmit = async () => {
       if (IS_DEMO) {
            toast.error("This action is disabled in the demo version.");
            return;
        }

    const formPayload = new FormData();
    Object.entries(formData).forEach(([key, value]) => {
      formPayload.append(key, value);
    });

    if (image) {
      formPayload.append("image", image[0]);
    }
    try {
      await postData("/index-bannerupdate", formPayload, "multipart/form-data");
      toast.success("Settings updated successfully!");
      refetch();
    } catch (err) {
      toast.error(err?.response?.data?.message || "Failed to update settings");
    }
  };





  const { makeRequest } = Apimethod()

  const [localStatus, setLocalStatus] = useState<number | null>(null);

  useEffect(() => {
    if (data?.data?.status !== undefined) {
      setLocalStatus(data?.data.status);
    }
  }, [data]);


  const handleStatusToggle = useCallback(async () => {
       if (IS_DEMO) {
            toast.error("This action is disabled in the demo version.");
            return;
        }
    const currentStatus = localStatus === 1 ? 1 : 0;
    const newStatus = currentStatus === 1 ? 0 : 1;

    setLocalStatus(newStatus); // Instantly update toggle status on UI

    try {
      const response = await makeRequest(
        '/update-frontedstatus',
        {
          status: newStatus,
          id: data?.data?.main_id || "",
        },
        'application/json',
        'POST'
      );

      toast.success(`Status updated to ${newStatus === 1 ? 'Enabled' : 'Disabled'}`);
      refetch(); // Refresh backend data
    } catch (error) {
      toast.error("Failed to update status.");
      setLocalStatus(currentStatus); // Revert on error
    }
  }, [makeRequest, data, localStatus]);


  return (
    <>


      <div className=" w-full  flex justify-center  items-center    mb-4">

        <ToggleSwitchSettingLogin
          label="Enable"
          enabled={localStatus === 1}
          loading={isLoading}
          onChange={handleStatusToggle}
        />
      </div>

      <h2 className="text-textcolor font-semibold font-poppins text-xl pb-4"> Banner</h2>
      <div className="border border-bordercolor bg-primary rounded-lg p-4 mt-5 md:mt-0">
        <div className="   w-full  grid     gap-4 ">


          <InputField
            label="Play Store Url"
            value={formData.play_store_url}
            placeholder="Enter play_store_url"
            onChange={(e) => handleChange("play_store_url", e.target.value)}
          />
          <InputField
            label="App Store Url"
            value={formData.app_store_url}
            placeholder="Enter play_store_url"
            onChange={(e) => handleChange("app_store_url", e.target.value)}
          />

          <IMageBaner />

          <div className="flex justify-center py-6 place-items-center">
            <button
              className={`px-24 py-3 font-medium cursor-pointer text-white rounded-xl bggradient`}
              onClick={handleSubmit}

            >
              {loading ? "Submitting..." : "Submit"}
            </button>
          </div>
        </div>
      </div>


    </>
  );
}

export default SponsorStores;
