import toast from "react-hot-toast";
import { useAppSelector } from "../../../Hooks/Hooks";
import useApiPost from "../../../Hooks/PostData";
import FrontEndCategory from "./FrontEndCategory";
import { useGetDataWithToken } from "../../../Appstore/Api/UsegetRefundpolicy";
import Apimethod from "../../../Hooks/Apimethod";
import { useCallback, useEffect, useState } from "react";
import ToggleSwitchSettingLogin from "../../../Componets/ToggleSwitchSettingLogin";

function Slider() {
    const { loading, postData } = useApiPost();

    const selectedCategories = useAppSelector((state) => state.FrontEdnSlicevaluesStore.selectedCategories);


     const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';


    const handleSubmit = async () => {
        if (IS_DEMO) {
            toast.error("This action is disabled in the demo version.");
            return;
        }
        const categoryIds = selectedCategories.map((cat) => cat.id).join(",");

        const formPayload = new FormData();
        formPayload.append("category_id", categoryIds);

        try {
            await postData("/indexcategory-update", formPayload, "multipart/form-data");
            toast.success("Settings updated successfully!");
        } catch (error) {
            console.error("Failed to update categories:", error);
        }
    };


     const { data: updatethedata, refetch ,isLoading } = useGetDataWithToken(
            "/indexcategory-update",
            ["indexcategory-update"]
        );



            const { makeRequest } = Apimethod()
        
            const [localStatus, setLocalStatus] = useState<number | null>(null);
        
            useEffect(() => {
                if (updatethedata?.categories?.[0]?.status !== undefined) {
                    setLocalStatus(updatethedata.categories[0].status);
                }
            }, [updatethedata]);
        
        
            const handleStatusToggle = useCallback(async () => {

                if (IS_DEMO) {
            toast.error("This action is disabled in the demo version.");
            return;
        }
                const currentStatus = localStatus === 1 ? 1 : 0;
                const newStatus = currentStatus === 1 ? 0 : 1;
        
                setLocalStatus(newStatus); // Instantly update toggle status on UI
        
                try {
                    const response = await makeRequest(
                        '/update-frontedstatus',
                        {
                            status: newStatus,
                            id: updatethedata?.categories?.[0]?.main_id || "",
                        },
                        'application/json',
                        'POST'
                    );
        
                    toast.success(`Status updated to ${newStatus === 1 ? 'Enabled' : 'Disabled'}`);
                    refetch(); // Refresh backend data
                } catch (error) {
                    toast.error("Failed to update status.");
                    setLocalStatus(currentStatus); // Revert on error
                }
            }, [makeRequest, updatethedata, localStatus]);
        

    return (
        <>

        <div className=" mb-4">
              <ToggleSwitchSettingLogin
                label="Enable"
                enabled={localStatus === 1}
                loading={isLoading}
                onChange={handleStatusToggle}
            />
        </div>
            <h2 className="text-textcolor font-semibold font-poppins text-xl pb-4">Categories</h2>
            <div className="border border-bordercolor bg-primary rounded-lg p-4 mt-5 md:mt-0">
                <div className="grid gap-4 pb-5">
                    <FrontEndCategory />
                </div>
                <div className="flex justify-center py-6 place-items-center">
                    <button
                        onClick={handleSubmit}
                        className={`px-24 py-3 font-medium text-white rounded-xl  cursor-pointer bggradient 
              `}
                    >
                        {loading ? "Submitting..." : "Submit"}
                    </button>
                </div>
            </div>
        </>
    );
}

export default Slider;
