import { useEffect, useState } from "react";
import { useSelector } from "react-redux";
import { Link } from "react-router-dom";
import SearchBar from "../../Componets/SearchBar/SearchBar";
import General from "../../assets/Images/set1.png";
import slider12 from "../../assets/Images/slider.png"
import slider1 from "../../assets/Images/slider1.png"
import sms from "../../assets/Images/smsSetting.png";
import mail from "../../assets/Images/store11.png";
import General1 from "../../assets/Images/download.png";
import sms1 from "../../assets/Images/3333.png";
import mail1 from "../../assets/Images/store12.png";
import { PiFileArrowUpLight } from "react-icons/pi";
import { IoCloudyOutline } from "react-icons/io5";
import Apimethod from "../../Hooks/Apimethod";
import { useAppDispatch } from "../../Hooks/Hooks";
import { setAppConfig } from "../../Appstore/Slice/appConfigSlice";
import Slider from "./Slider/Slider";
import CategoriesF from "./CategoriesF/CategoriesF";
import SponsorStores from "./SponsorStores/SponsorStores";
import Cities from "./Cities/Cities";
import Banner from "./Banner/Banner";
import PerfectStores from "./PerfectStores/PerfectStores";
import Testimonials from "./Testimonials/Testimonials";
import SEO from "./SEO/SEO";
import SponsorStoresCard from "./SponsorStoresCard/SponsorStoresCard";
import rr from "../../assets/Images/1.png"
import r from "../../assets/Images/11.png"
import Card from "../../assets/Images/cards.png"
import city from "../../assets/Images/city.png"
import city1 from "../../assets/Images/city1.png"
import baner from "../../assets/Images/baner.png"
import baner1 from "../../assets/Images/baner1.png"
import shop from "../../assets/Images/shop (1).png"
import shop1 from "../../assets/Images/shop.png"
import test from "../../assets/Images/test.png"
import test1 from "../../assets/Images/test1.png"
import seo  from  "../../assets/Images/seo.png"
import seo1  from  "../../assets/Images/seo1.png"

const options = [
    {
        key: "Slider",
        label: "Slider",
        iconLight: slider12,
        iconDark: slider1,
        component: <Slider />,
    },
    {
        key: "Categories",
        label: "Categories",
        iconLight: rr,
        iconDark: r,
        component: <CategoriesF />,
    },
    {
        key: "SponsorStores",
        label: "Card",
        iconLight: Card,
        iconDark: sms1,
        component: <SponsorStores />,
    },
    {
        key: "SponsorStoresCard",
        label: "Sponsor Stores",
        iconLight: mail,
        iconDark: mail1,
        component: <SponsorStoresCard />,
    },
    {
        key: "Cities",
        label: "Cities",
        iconLight: city,
        iconDark: city1,
        component: <Cities />,
    },
    {
        key: "Banner",
        label: "Banner",
        iconLight: baner,
        iconDark: baner1,
        component: <Banner />,
    },
    {
        key: "PerfectStores",
        label: "Perfect Stores",
        iconLight: shop1,
        iconDark: shop,
        component: <PerfectStores />,
    },

    {
        key: "Testimonials",
        label: "Testimonials",
        iconLight: test1,
        iconDark: test,
        component: <Testimonials />,
    },

    {
        key: "SEO",
        label: "SEO",
         iconLight: seo,
        iconDark: seo1,
        component: <SEO />,
    },
];

function FrontEnd() {
    const isSidebarOpen = useSelector((state: any) => state.sidebar.isOpen);
    const [option, setOption] = useState("Slider");

    const selectedComponent = options.find(opt => opt.key === option)?.component;









    return (
        <div className={`bg-primary ${isSidebarOpen ? "xl:pl-20" : "xl:pl-72"}`}>
            <SearchBar />

            <div className="px-4 pb-10 xl:px-6">
                {/* Page Header */}
                <div className="flex justify-between py-3">
                    <h2 className="text-textcolor font-poppins text-xl font-semibold pt-3 ">Front End</h2>
                </div>

                {/* Breadcrumb */}
                <div className="w-full flex flex-col md:flex-row justify-between items-center gap-2">
                    <div className="flex items-center gap-2">
                        <Link to="/dashboard">
                            <h3 className="text-base font-semibold text-[#3A3A3A]  font-poppins">Dashboard</h3>
                        </Link>
                        <div className="h-1 w-1 rounded-full bg-[#E0E0E0]"></div>
                        <h3 className="text-base text-[#858585] font-poppins">Front End</h3>
                    </div>
                </div>

                {/* Settings Section */}
                <div className="border border-bordercolor  p-6 rounded-lg mt-8 mx-4 sm:mx-0 overflow-x-auto w-full">
                    <div className="xl:overflow-x-auto lg:overflow-x-auto 2xl:overflow-hidden   xl:min-w-[1200px]">
                        <div className="md:flex gap-14">
                            {/* Sidebar Options */}
                            <div className="flex flex-col gap-4  ">
                                {options.map(({ key, label, iconLight, iconDark, icon }) => (
                                    <button
                                        key={key}
                                        onClick={() => setOption(key)}
                                        className={`flex items-center gap-2 px-4 py-3.5 rounded-xl cursor-pointer lg:w-[320px] md:w-[220px]
                                            ${option === key ? "bggradient" : "border border-bordercolor"}`}
                                    >
                                        {icon ? (
                                            <span className={`${option === key ? "text-[#FFFFFF]" : "text-textcolor"} dark:text-[#FFFFFF]`}>{icon}</span>
                                        ) : (
                                            <>
                                                <img src={option === key ? iconDark : iconLight} className="block w-5 h-5 dark:hidden" />
                                                <img src={iconDark} className="hidden w-5 h-5 dark:block" />
                                            </>
                                        )}
                                        <p className={`font-poppins text-sm font-normal ${option === key ? "text-[#FFFFFF]" : "text-textcolor"}`}>{label}</p>
                                    </button>
                                ))}
                            </div>

                            {/* Component Display */}
                            <div className="w-full">{selectedComponent}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    );
}

export default FrontEnd;
