import React, { useCallback, useEffect, useMemo, useState } from 'react';
import { useGetDataWithToken } from '../../../Appstore/Api/UsegetRefundpolicy';
import InputField from '../../../Componets/InputField';
import toast from 'react-hot-toast';
import useApiPost from '../../../Hooks/PostData';
import SliderImage from './SliderImage';
import { useAppSelector } from '../../../Hooks/Hooks';
import { clearCoverImage } from '../../../Appstore/Slice/UpdateCategoryImageSlice';

function Slider() {
  const { data, isLoading, error, refetch } = useGetDataWithToken("/indexslider-update", ["indexslider-update"]);
  const image = useAppSelector((state) => state.UpdateCategoryImageSlice.cover_image);

  const [initialData, setInitialData] = useState(null);
  const [formData, setFormData] = useState({
    title: "",
    link: "",
    body: "",
  });

      const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';


  const [initialImage, setInitialImage] = useState(null);
  const [isEdited, setIsEdited] = useState(false);
  const { loading, postData } = useApiPost();

  // Avoid logging null values repeatedly
  useEffect(() => {
    if (image) console.log("Updated image", image);
  }, [image]);

  // Store image in sessionStorage for reference (if needed)
  useEffect(() => {
    if (data?.data?.image) {
      sessionStorage.setItem("Image", data.data.image);
      setInitialImage(data.data.image);
    }
  }, [data]);

  useEffect(() => {
    if (data?.data) {
      const { title, link, body } = data.data;
      const defaultForm = {
        title: title || "",
        link: link || "",
        body: body || "",
      };
      setFormData(defaultForm);
      setInitialData(defaultForm);
    }
  }, [data]);

  const handleChange = useCallback((field: string, value: string) => {


    setFormData((prev) => ({ ...prev, [field]: value }));
  }, []);

  // Form edit detection (include image change)
  const isFormEdited = useMemo(() => {
    if (!initialData) return false;
    const formChanged = Object.keys(formData).some(
      (key) => formData[key] !== initialData[key]
    );
    const imageChanged = image && image !== initialImage;
    return formChanged || imageChanged;
  }, [formData, initialData, image, initialImage]);

  useEffect(() => {
    setIsEdited(isFormEdited);
  }, [isFormEdited]);

  const handleSubmit = async () => {

      if (IS_DEMO) {
            toast.error("This action is disabled in the demo version.");
            return;
        }
    if (!isEdited) return;

    const formPayload = new FormData();
    Object.entries(formData).forEach(([key, value]) => {
      formPayload.append(key, value);
    });

    if (image && image !== initialImage) {
      formPayload.append("image", image[0]);
    }

    try {
      await postData("/indexslider-update", formPayload, "multipart/form-data");
      toast.success("Settings updated successfully!");
      setIsEdited(false);
      refetch();
      clearCoverImage()
    } catch (err) {
      toast.error(err?.response?.data?.message || "Failed to update settings");
    }
  };

  return (
    <>
      <h2 className="text-textcolor font-semibold font-poppins text-xl pb-4">Slider</h2>
      <div className="border border-bordercolor bg-primary rounded-lg p-4 mt-5 md:mt-0">
        <div className="grid gap-4 pb-5 ">
          <InputField
            label="Title"
            value={formData.title}
            placeholder="Enter title"
            onChange={(e) => handleChange("title", e.target.value)}
          />

          <InputField
            label="Button Link"
            value={formData.link}
            placeholder="Enter Button Link"
            onChange={(e) => handleChange("link", e.target.value)}
          />

          <div className="flex flex-col gap-2">
            <label className="font-poppins text-sm font-medium text-textcolor">
              Description<span className="text-[#F21818] pl-1">*</span>
            </label>
            <textarea
              value={formData.body}
              onChange={(e) => handleChange("body", e.target.value)}
              placeholder="Enter description..."
              rows={4}
              className="w-full rounded-lg border border-bordercolor bg-primary px-4 py-2.5 text-sm text-textcolor placeholder:text-placeholdercolor focus:outline-none resize-none"
            />

            <SliderImage />
          </div>
        </div>

        <div className="flex justify-center py-6 place-items-center">
          <button
            onClick={handleSubmit}
            disabled={!isEdited}
            className={`px-24 py-3 font-medium cursor-pointer text-white rounded-xl ${isEdited ? "bggradient" : "bggradient opacity-50 cursor-not-allowed"}`}
          >
            {loading ? "Submitting..." : "Submit"}
          </button>
        </div>
      </div>
    </>
  );
}

export default Slider;
