import React, { useCallback, useEffect, useState } from 'react'
import CategoryListFrontendCard from './CategoryListFrontendCard'
import { useGetDataWithToken } from '../../../Appstore/Api/UsegetRefundpolicy';
import { useAppDispatch, useAppSelector } from '../../../Hooks/Hooks';
import { setIndexCardData } from '../../../Appstore/Slice/IndexCardSlice';
import InputField from '../../../Componets/InputField';
import IMageCard1 from './IMageCard1';
import useApiPost from '../../../Hooks/PostData';
import toast from 'react-hot-toast';

function Card1() {

    const { data, isLoading, error, refetch } = useGetDataWithToken("/indexcard1-update", ["indexcard1-update"]);

    const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';

    const { postData, loading } = useApiPost()


    const dispatch = useAppDispatch()

    const selectedCategory = useAppSelector(
        (state) => state.CategorySelectedIDandValuesUpdate.selectedCategory
    );


    const image = useAppSelector((state) => state.UpdateCategoryImageSlice.cover_image)

    useEffect(() => {
        if (data?.data) {
            dispatch(setIndexCardData(data.data));
        }
    }, [data, dispatch]);



    const indexCard = useAppSelector((state) => state.indexCardSlice)

    console.log(" my slectted alues in slice", indexCard)

    const [formData, setFormData] = useState({
        title: "",
    });


    useEffect(() => {
        if (data?.data) {
            const { title } = data.data;
            const defaultForm = {
                title: title || "",

            };
            setFormData(defaultForm);
        }
    }, [data]);


    const handleChange = useCallback((field: string, value: string) => {
        setFormData((prev) => ({ ...prev, [field]: value }));
    }, []);



    const handleSubmit = async () => {
if (IS_DEMO) {
            toast.error("This action is disabled in the demo version.");
            return;
        }
        const formPayload = new FormData();
        Object.entries(formData).forEach(([key, value]) => {
            formPayload.append(key, value);
        });

        if (image) {
            formPayload.append("image", image[0]);
        }

        if (selectedCategory) {
            formPayload.append("category_id", selectedCategory.id)
        }
        formPayload.append("title", formData.title)
        try {
            await postData("/indexcard1-update", formPayload, "multipart/form-data");
            toast.success("Settings updated successfully!");
            refetch();
        } catch (err) {
            toast.error(err?.response?.data?.message || "Failed to update settings");
        }
    };




    return (
        <div className=' w-full  h-fit flex flex-col  gap-4 rounded-md  p-4 shadow-lg border border-bordercolor '>
            {/*  card 1  values  */}

            <h3 className=' font-poppins  font-normal pb-4   text-textcolor  text-lg'> CARD 1</h3>
            <CategoryListFrontendCard />
            <InputField
                label="Title"
                value={formData.title}
                placeholder="Enter title"
                onChange={(e) => handleChange("title", e.target.value)}
            />
            <IMageCard1 />

            <div className="flex justify-center py-6 place-items-center">
                <button
                    className={`px-24 py-3 font-medium cursor-pointer text-white rounded-xl bggradient`}
                    onClick={handleSubmit}

                >
                    {loading ? "Submitting..." : "Submit"}
                </button>
            </div>
        </div>
    )
}

export default Card1
