"use client";
import { useDispatch } from "react-redux";
import { useEffect, useMemo, useState } from "react";
import { MdOutlineCheck, MdOutlineChevronRight } from "react-icons/md";
import { useAppSelector } from "../../../Hooks/Hooks";
import { UseGetCategory } from "../../../Appstore/Api/UseGetCategory";
import { toggleCategorySelectionUpdate4 } from "../../../Appstore/Slice/CategorySelectedIDandValuesUpdateFronentCard4";


interface CategoryDropdownProps {
  required?: boolean;
}

const CategoryListFrontendCard4: React.FC<CategoryDropdownProps> = () => {
  const dispatch = useDispatch();
  const { data } = UseGetCategory();




  const giftId = useAppSelector(
    (state) => state.indexCardSlice4.category_id
  );

  console.log(" my default categroy_id", giftId)


  const selectedCategory = useAppSelector(
    (state) => state.CategorySelectedIDandValuesUpdateFronentCard4.selectedCategory
  );



  console.log(" my selected  slice values" , selectedCategory)

  const categories = useMemo(
    () =>
      data?.data?.map((item) => ({
        id: item.id,
        category_name: item.category_name,
      })) || [],
    [data]
  );

  const [searchValue, setSearchValue] = useState("");
  const [showDropdown, setShowDropdown] = useState(false);
  const [rotate, setRotate] = useState(false);

  // Sync default selection from SubCategoryUpdateSlice
  useEffect(() => {
    if (
      giftId &&
      categories.length > 0 &&
      (!selectedCategory || selectedCategory.id !== giftId)
    ) {
      const found = categories.find((cat) => cat.id === giftId);

      console.log(" my match values in slice ", giftId)

      if (found) {
        dispatch(toggleCategorySelectionUpdate4({
          id: found.id,
          category_name: found.category_name,
        }));
      }
    }
  }, [giftId, categories]);

  useEffect(() => {
    setSearchValue(selectedCategory?.category_name || "");
  }, [selectedCategory]);

  const handleSelectCategory = (categoryName: string, categoryId: number) => {
    if (selectedCategory?.id === categoryId) {
      // Already selected; clear the selection
      dispatch(toggleCategorySelectionUpdate4({ id: null, category_name: "" }));
    } else {
      dispatch(toggleCategorySelectionUpdate4({
        id: categoryId,
        category_name: categoryName,
      }));
    }
    setShowDropdown(false);
    setRotate(false);
  };

  const handleFocus = () => {
    setShowDropdown(true);
    setRotate(true);
  };

  const handleBlur = () => {
    // Delay hiding to allow onMouseDown selection
    setTimeout(() => {
      setShowDropdown(false);
      setRotate(false);
    }, 150);
  };

  const handleToggle = () => {
    setShowDropdown((prev) => !prev);
    setRotate((prev) => !prev);
  };

  const isSelected = (id: number) => selectedCategory?.id === id;

  return (
    <div className="w-full flex flex-col relative h-full">
      <label
        htmlFor="category"
        className="font-poppins text-sm font-medium text-textcolor"
      >
        Category
        <span className="text-[#F21818] pl-[1px]">*</span>
      </label>

      <div className="relative mt-2 flex items-center cursor-pointer">
        <input
          type="text"
          id="category"
          name="category"
          autoComplete="off"
          readOnly
          spellCheck="false"
          className="w-full rounded-lg border border-bordercolor bg-primary px-4 py-2.5 my-1 text-textcolor cursor-pointer placeholder:font-gilroy_regular placeholder:text-sm placeholder:text-textcolor placeholder:opacity-50 focus:outline-none focus:ring-1 focus:ring-header"
          placeholder="Select Categories"
          value={searchValue}
          onFocus={handleFocus}
          onBlur={handleBlur}
        />
        <div
          className={`absolute right-2 text-xl transition-transform cursor-pointer ${rotate ? "rotate-90" : "-rotate-90"}`}
          onClick={handleToggle}
        >
          <MdOutlineChevronRight />
        </div>
      </div>

      {selectedCategory?.id && (
        <div className="flex flex-wrap mt-2 gap-2 hidden">
          <span className="flex items-center bg-[#1c5bb9c4] text-white px-3 py-1 rounded-full text-sm font-poppins">
            {selectedCategory.category_name}
            <button
              type="button"
              className="ml-2 text-red-500 hover:text-red-700"
              onClick={() =>
                dispatch(toggleCategorySelectionUpdate4({ category_name: "", id: null }))
              }
            >
              ×
            </button>
          </span>
        </div>
      )}

      {showDropdown && (
        <ul className="absolute top-[5.9rem] left-0 w-full bg-primary text-textcolor rounded-lg shadow-lg max-h-[200px] overflow-y-auto z-10 border border-bordercolor mt-1">
          {categories.length > 0 ? (
            categories.map((cat) => (
              <li
                key={cat.id}
                className="px-4 py-2 cursor-pointer font-poppins hover:bg-gray-200 text-textcolor flex justify-between items-center"
                onMouseDown={() =>
                  handleSelectCategory(cat.category_name, cat.id)
                }
              >
                {cat.category_name}
                {isSelected(cat.id) && (
                  <MdOutlineCheck className="text-[#6565657a] text-lg" />
                )}
              </li>
            ))
          ) : (
            <li className="px-4 py-2 font-poppins text-center text-gray-500">
              No categories found
            </li>
          )}
        </ul>
      )}
    </div>
  );
};

export default CategoryListFrontendCard4;
