import { shallowEqual, useSelector } from "react-redux";
import SearchBar from "../../Componets/SearchBar/SearchBar";
import { Link, useNavigate } from "react-router-dom";
import WithoutSorttableHeader from "../../Componets/TableComponets/WithoutSorttableHeader";
import Search from "../../assets/Images/search.png";
import Add from "../../assets/Images/add.png";
import { useAppDispatch, useAppSelector } from "../../Hooks/Hooks";
import useApiPost from "../../Hooks/PostData";
import { useEffect, useState } from "react";
import notfound from "../../assets/Images/notfound.png";
import AvatarWithSpinner from "../../Componets/LoadingComponest";
import TableUserInfo from "../../Componets/TableComponets/TableUserInfo";
import SimpletextTableBody from "../../Componets/TableComponets/SimpletextTableBody";
import EditIcon from "../../assets/Images/edit.png";
import TableActionButtons from "../../Componets/TableComponets/TableActionButtons";
import Block from "../../assets/Images/deleteicon.png";
import TableDateTimeDisplay from "../../Componets/TableComponets/TableDateTimeDisplay";
import ServiceListPagination from "../../Componets/PaginationComponets/ServiceListPagination";
import { setPaginationServiceList } from "../../Appstore/Slice/PaginationSlice/ServicelistPaginationSlice";
import { clearSelectedCategory } from "../../Appstore/Slice/CategorySelectedIDandValues";
import { clearAllCoverImages } from "../../Appstore/Slice/UploadAddserviceImageSlice";
import { clearCoverImageatc } from "../../Appstore/Slice/UploadServiceAttactmentSlice";
import { reset } from "../../Appstore/Slice/toggleSlice";
import { showModal } from "../../Appstore/Slice/ModalSlice";
import { resetStore } from "../../Appstore/Slice/storeSliceUpdate";
import { clearSelectedStoreid } from "../../Appstore/Slice/UpdateSelectedStoreIDSlice";
import toast from "react-hot-toast";
import { clearAllStores } from "../../Appstore/Slice/storennameslicemultiple";
import SimpletextTableBodyReview from "../../Componets/TableComponets/SimpletextTableBodyReview";

function ServiceList() {
    const isSidebarOpen = useSelector((state: any) => state.sidebar.isOpen);
    const { data, loading, error, postData } = useApiPost();
    const pagination = useAppSelector((state) => state.ServicelistPaginationSlice);
    const { current_page, records_per_page } = pagination;
    const [search, setSearch] = useState("");

    const isapicall = useAppSelector((state) => state.toggle.value);

    const dispatch = useAppDispatch();

    // Fetch data
    useEffect(() => {
        const params = {
            page: current_page,
            pageSize: records_per_page,
            search: search.trim(),
        };

        postData("/store-listadmin", params);
    }, [current_page, records_per_page, search]);

    //   isapicall
    // Fetch data
    useEffect(() => {
        if (isapicall) {
            const data = new FormData();
            postData("/store-listadmin", data);
        }
    }, [isapicall]);




    const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';


    useEffect(() => {
        if (data?.Pagination) {
            dispatch(setPaginationServiceList(data?.Pagination));
        }
    }, [data, dispatch]);

    const navigate = useNavigate();

    const handleNaviagte = () => {

        navigate(`/add-service`);
        dispatch(clearSelectedCategory());
        dispatch(clearAllCoverImages());
        dispatch(clearCoverImageatc());
        dispatch(clearAllStores())
        dispatch(reset());
    };



    const handaldelete = (gift: string) => {

        sessionStorage.setItem("servicedeleteid", gift?.id || "");
        dispatch(showModal("ServiceDeleteModal"));
        dispatch(reset());
    };

    const handleNaviagteUpdate = (service: string) => {

        const currentPath = location.pathname.split("/")[1];
        navigate(`/${currentPath}/update-service`);
        dispatch(resetStore());
        dispatch(reset())
        dispatch(clearSelectedStoreid())
        dispatch(clearAllCoverImages())
        dispatch(clearCoverImageatc());
        sessionStorage.setItem("updateserviceid", service?.id);

    };



    const handalvendorview = (gift: string) => {
        sessionStorage.setItem("user_id", gift?.vendor_id)
        navigate(`/View-Vendor`);
    };




    console.log("datadatadata", data?.ServiceList)

    return (
        <div className={`bg-primary ${isSidebarOpen ? "xl:pl-20" : "xl:pl-72"}`}>
            <SearchBar />
            <div className="px-4 pb-10 xl:px-6">
                <div className="flex justify-between border-t-[#F2F2F2] py-3">
                    <h2 className="text-textcolor font-poppins text-xl font-semibold pt-3">Service List</h2>
                    <div className="relative">
                        <div className="absolute left-2 top-1/2 flex transform -translate-y-1/2 items-center p-2">
                            <img src={Search} alt="Search" className="h-4 w-4 md:h-5 md:w-5" />
                        </div>
                        <div className=" w-full">
                            <input
                                type="text"
                                placeholder="Search by service-name..."
                                className="w-[180px] md:w-[250px] pl-10 py-2 text-sm placeholder:text-placeholdercolor
              border border-bordercolor border-opacity-10 rounded-lg bg-[#00000005] 
              focus:outline-none focus:ring-1 focus:ring-gray-600 
              placeholder:dark:text-tableDarkLarge "
                                onChange={(e) => setSearch(e.target.value)}
                                value={search}
                            />
                        </div>
                    </div>
                </div>

                <div className="flex items-center    flex-col  md:flex-row    gap-y-4 justify-between">
                    <div className="flex items-center gap-2">
                        <Link to="/dashboard">
                            <h3 className="text-[#3A3A3A] font-poppins text-base font-semibold">Dashboard</h3>
                        </Link>
                        <div className="rounded-full w-1 h-1 bg-[#E0E0E0]" />
                        <h3 className="text-[#858585] font-poppins text-base">Service List</h3>
                    </div>

                    <button className="flex gap-1.5 mr-1 py-2 cursor-pointer place-items-center px-4 font-poppins font-medium text-white rounded-md bggradient" onClick={handleNaviagte}>
                        <img src={Add} className="w-4 h-4" />
                        <p className="md:text-sm text-xs">Add Service</p>
                    </button>
                </div>

                <div className="relative border border-bordercolor rounded-lg mt-8 mx-4 sm:mx-0 overflow-x-auto w-full">
                    <div className="min-w-[1200px]">
                        {/* Table Header */}
                        <div className="w-full flex items-center px-4 py-4 text-left border-b bg-headercolortable border-bordercolor sm:pl-8 gap-4">
                            <div className="w-[5%]">
                                <WithoutSorttableHeader label="S.L" />
                            </div>
                            <div className="w-[20%]">
                                <WithoutSorttableHeader label="SERVICE" />
                            </div>
                            <div className="w-[15%]">
                                <WithoutSorttableHeader label="VENDOR" />
                            </div>
                            <div className="w-[25%]">
                                <WithoutSorttableHeader label="STORE" />
                            </div>
                            <div className="w-[8%] pl-4">
                                <WithoutSorttableHeader label="PRICE" />
                            </div>
                            <div className="w-[10%]">
                                <WithoutSorttableHeader label="CREATED DATE/TIME" />
                            </div>
                            <div className="w-[12%] pl-8">
                                <WithoutSorttableHeader label="ACTION" />
                            </div>
                        </div>

                        <div className="relative">
                            {loading ? (
                                <div className="h-[400px] flex items-center justify-center">
                                    <AvatarWithSpinner />
                                </div>
                            ) : data?.ServiceList?.length > 0 ? (
                                data.ServiceList.map((gift: any, index: number) => (
                                    <div
                                        key={gift.gift_id}
                                        className={`flex items-start px-4 py-3 border-b border-bordercolor sm:pl-8 gap-4 ${index % 2 === 0 ? "bg-white dark:bg-primary" : "bg-[#00162e0a] dark:bg-primary"
                                            }`}
                                    >
                                        {/* S.L */}
                                        <div className="w-[5%] text-sm text-textcolor font-poppins pt-2">
                                            {(current_page - 1) * records_per_page + index + 1}
                                        </div>

                                        {/* Service */}
                                        <div className="w-[20%] flex gap-3 items-center min-w-[200px]">
                                            {/* Store Image */}
                                            <div className="w-10 h-10 rounded-full overflow-hidden flex-shrink-0 border border-gray-200">
                                                <img
                                                    src={gift.store_images[0]}
                                                    alt="Service"
                                                    className="w-full h-full object-cover"
                                                />
                                            </div>

                                            {/* Text Content */}
                                            <div className="flex flex-col">
                                                <h4 className="text-[#0046AE] text-sm font-poppins break-words leading-tight">
                                                    {gift.store_name}
                                                </h4>
                                                <p className="text-[#a4a9b4] text-xs font-poppins mt-1 leading-tight">
                                                    Price: {gift.price}
                                                </p>
                                            </div>
                                        </div>


                                        {/* Vendor */}
                                        <div className="w-[15%]">
                                            <TableUserInfo
                                                profilePic={gift.image}
                                                username={gift.vendor_name}
                                                email={gift.email || "N/A"}
                                                mobile={gift.country_code ? `${gift.country_code} ${gift.mobile || ""}` : "N/A"}
                                                onClick={() => handalvendorview(gift)}
                                            />
                                        </div>

                                        {/* Category */}
                                        <div className="w-[25%] whitespace-pre-wrap break-words text-textcolor leading-relaxed">
                                            <SimpletextTableBodyReview title={gift.service_names?.join(", ")} />
                                        </div>

                                        {/* Price */}
                                        <div className="w-[8%] pl-4">
                                            <SimpletextTableBody title={gift.price} />
                                        </div>

                                        {/* Date/Time */}
                                        <div className="w-[10%]">
                                            <TableDateTimeDisplay dateString={gift.created_at} />
                                        </div>

                                        {/* Actions */}
                                        <div className="w-[12%] flex items-center gap-2 justify-center pl-8">
                                            <button
                                                className="py-[8.5px] px-[10px] bg-[#D0CCE1]/60 rounded-full cursor-pointer"
                                                onClick={() => handleNaviagteUpdate(gift)}
                                            >
                                                <img src={EditIcon} alt="Edit" className="w-5 h-4" />
                                            </button>

                                            <TableActionButtons
                                                onBlockClick={() => handaldelete(gift)}
                                                viewButtonColor="#CCE1CD"
                                                blockButtonColor="#FDE4EA"
                                                borderColor="#01D312"
                                                blockButtonIcon={Block}
                                            />
                                        </div>
                                    </div>
                                ))
                            ) : (
                                <div className="p-4 h-[38rem] flex justify-center items-center">
                                    <div className="w-full flex flex-col items-center h-full justify-center">
                                        <img src={notfound} alt="Not Found" className="w-1/2 max-h-[40vh] object-contain" />
                                        <h2 className="font-poppins text-lg text-textcolor mt-4">No Data Found</h2>
                                    </div>
                                </div>
                            )}
                        </div>
                    </div>
                    <ServiceListPagination />
                </div>

            </div>
        </div>
    );
}
export default ServiceList;
