import { useEffect, useId, useState } from 'react';
import { useSelector } from 'react-redux';
import { Link } from 'react-router-dom';
import SearchBar from '../../Componets/SearchBar/SearchBar';
import WithoutSorttableHeader from '../../Componets/TableComponets/WithoutSorttableHeader';
import useApiPost from '../../Hooks/PostData';
import notfound from "../../assets/Images/notfound.png";
import { useAppDispatch, useAppSelector } from '../../Hooks/Hooks';
import SimpletextTableBody from '../../Componets/TableComponets/SimpletextTableBody';
import TableDateTimeDisplay from '../../Componets/TableComponets/TableDateTimeDisplay';
import toast from 'react-hot-toast';
import Apimethod from '../../Hooks/Apimethod';
import TableActionButtons from '../../Componets/TableComponets/TableActionButtons';
import AvatarWithSpinner from '../../Componets/LoadingComponest';
import Block from "../../assets/Images/deleteicon.png";
import EditIcon from "../../assets/Images/edit.png";
import LanguageListPagination from '../../Componets/PaginationComponets/LanguageListPagination';
import { setPaginationLanguageList } from '../../Appstore/Slice/PaginationSlice/LanguageListPaginationSlice';
import TableUserInfo from '../../Componets/TableComponets/TableUserInfo';
import SimpletextTableBodyReview from '../../Componets/TableComponets/SimpletextTableBodyReview';
import { showModal } from '../../Appstore/Slice/ModalSlice';
import { reset } from '../../Appstore/Slice/toggleSlice';

function ServiceReviewsList() {
    const isSidebarOpen = useSelector((state: any) => state.sidebar.isOpen);
    const { data, loading, postData } = useApiPost();
    const [search, setSearch] = useState("");
    const pagination = useAppSelector((state) => state.LanguageListPaginationSlice);
    const { current_page, records_per_page } = pagination;
    const dispatch = useAppDispatch();
    const { makeRequest } = Apimethod();
    const isAddGiftValues = useAppSelector((state) => state.toggle.value);
    const [toggleStates, setToggleStates] = useState<{ [key: number]: boolean }>({});




    useEffect(() => {
        const params = {
            page: current_page,
            pageSize: records_per_page,
            search: search.trim()
        };
        postData("/review-list", params);
    }, [current_page, records_per_page, search]);


    console.log("isAddGiftValues", isAddGiftValues)

    useEffect(() => {
        if (isAddGiftValues) {
            postData("/review-list", {});
        }
    }, [isAddGiftValues]);

    useEffect(() => {
        if (data?.reviewlist) {
            const toggles = data.reviewlist.reduce((acc: any, review: any) => {
                acc[review.id] = review.status;
                return acc;
            }, {});
            setToggleStates(toggles);
        }
    }, [data]);

    useEffect(() => {
        if (data?.Pagination) {
            dispatch(setPaginationLanguageList(data.Pagination));
        }
    }, [data, dispatch]);


    const handleBlock = (userId: number) => {
       
        dispatch(reset())
        dispatch(showModal("DeleteReviewModal"))
        sessionStorage.setItem("DeleteReviewID", userId.toString())

    };

    const handalUpdate = (userId: number) => {
      

        sessionStorage.setItem("UpdateReviewID", userId.toString())
        dispatch(reset())
        dispatch(showModal("UpdateReviewModal"))

    }

    return (
        <div className={`bg-primary ${isSidebarOpen ? "xl:pl-20" : "xl:pl-72"}`}>
            <SearchBar />
            <div className="px-4 pb-10 xl:px-6">
                <div className="flex justify-between border-t-[#F2F2F2] py-3">
                    <h2 className="text-textcolor font-poppins text-xl font-semibold pt-3">Reviews List</h2>
                </div>

                <div className="flex items-center justify-between">
                    <div className="flex items-center gap-2">
                        <Link to="/dashboard">
                            <h3 className="text-[#3A3A3A] font-poppins text-base font-semibold">Dashboard</h3>
                        </Link>
                        <div className="rounded-full w-1 h-1 bg-[#E0E0E0]" />
                        <h3 className="text-[#858585] font-poppins text-base">Reviews List</h3>
                    </div>
                </div>

                <div className="relative border border-bordercolor rounded-lg mt-8 mx-4 sm:mx-0 overflow-x-auto w-full">
                    <div className="min-w-[1200px]">
                        {/* Table Header */}
                        <div className="flex items-center px-4 py-4 text-left border-b bg-headercolortable border-b-bordercolor sm:pl-8 gap-4">
                            <div className="w-[2%]"><WithoutSorttableHeader label="S.L" /></div>
                            <div className="w-[18%]"><WithoutSorttableHeader label="REVIEWER" /></div>
                            <div className="w-[18%]"><WithoutSorttableHeader label="STORE" /></div>
                            <div className="w-[5%]"><WithoutSorttableHeader label="STAR" /></div>
                            <div className="w-[30%]"><WithoutSorttableHeader label="REVIEW" /></div>
                            <div className="w-[12%]"><WithoutSorttableHeader label="CREATED DATE/TIME" /></div>
                            <div className="w-[10%]"><WithoutSorttableHeader label="ACTION" /></div>
                        </div>

                        {/* Table Body */}
                        <div className="relative">
                            {loading ? (
                                <div className="h-[400px] flex items-center justify-center">
                                    <AvatarWithSpinner />
                                </div>
                            ) : data?.reviewlist?.length > 0 ? (
                                data.reviewlist.map((review: any, index: number) => (
                                    <div
                                        key={review.id}
                                        className={`flex items-start px-4 py-4 border-b border-b-bordercolor sm:pl-8 gap-4 text-sm ${index % 2 === 0 ? 'bg-white dark:bg-primary' : 'bg-[#00162e0a] dark:bg-primary'}`}
                                    >
                                        {/* S.L */}
                                        <div className="w-[2%] pt-2 font-poppins text-textcolor">
                                            {(current_page - 1) * records_per_page + index + 1}
                                        </div>

                                        {/* Reviewer */}
                                        <div className="w-[18%]">
                                            <TableUserInfo
                                                profilePic={review.user_image}
                                                username={`${review.first_name} ${review.last_name}`}
                                                email={review.email || 'N/A'}
                                                mobile={review.country_code ? `${review.country_code} ${review.mobile || ''}` : 'N/A'}
                                                onClick={() => { }}
                                            />
                                        </div>

                                        {/* Store */}
                                        <div className="w-[18%] flex items-center gap-2">
                                            <div className="w-12 h-10 rounded-full overflow-hidden">
                                                <img
                                                    src={review.service_images[0]}
                                                    className="w-full h-full object-cover"
                                                    alt="Store"
                                                />
                                            </div>
                                            <SimpletextTableBody title={review.service_name} />
                                        </div>

                                        {/* Star */}
                                        <div className="w-[5%] pt-2">
                                            <SimpletextTableBody title={review.review_star} />
                                        </div>

                                        {/* Full Review Message - no truncation */}
                                        <div className="w-[30%] whitespace-pre-wrap break-words text-textcolor">
                                            <SimpletextTableBodyReview title={review.review_message} />
                                        </div>

                                        {/* Created Date */}
                                        <div className="w-[12%] pl-3">
                                            <TableDateTimeDisplay dateString={review.created_at} />
                                        </div>

                                        {/* Action Buttons */}
                                        <div className="w-[10%] flex items-center gap-2">
                                            <button className="py-[9px] px-[10px]  cursor-pointer bg-[#D0CCE1]/60 rounded-full" onClick={() => handalUpdate(review.id)} >
                                                <img src={EditIcon} alt="Edit" className="w-5 h-4" />
                                            </button>
                                            <TableActionButtons
                                                onBlockClick={() => handleBlock(review.id)}
                                                blockButtonColor="#FDE4EA"
                                                borderColor="#01D312"
                                                blockButtonIcon={Block}
                                            />
                                        </div>
                                    </div>
                                ))
                            ) : (
                                <div className="p-4 h-[38rem] flex justify-center items-center">
                                    <div className="w-full flex flex-col items-center">
                                        <img src={notfound} alt="Not Found" className="w-1/2 max-h-[40vh] object-contain" />
                                        <h2 className="font-poppins text-lg text-textcolor mt-4">No Reviews Found</h2>
                                    </div>
                                </div>
                            )}
                        </div>
                    </div>

                    {/* Pagination */}
                    <LanguageListPagination />
                </div>
            </div>
        </div>
    );
}

export default ServiceReviewsList;
