import React, { useEffect, useState } from "react";
import { useSelector } from "react-redux";
import { Link, useLocation, useNavigate } from "react-router-dom";
import SearchBar from "../../Componets/SearchBar/SearchBar";
import { useAppDispatch, useAppSelector } from "../../Hooks/Hooks";
import useApiPost from "../../Hooks/PostData";
import { setStore } from "../../Appstore/Slice/storeSliceUpdate";
import FormGlobalInputAnalytical from "../../Componets/Form/FormGlobalINputNlytical";
import UpdateServiceStore from "./UpdateServiceStore";
import UpdatesericeImage from "./UpdatesericeImage";
import UpdateServiceAttachment from "./UpdateServiceAttachment";
import toast from "react-hot-toast";
import UpdateSerivceTextEdit from "./UpdateSerivceTextEdit";
import { MdArrowBack } from "react-icons/md";

function ServiceUpdate() {
    const isSidebarOpen = useSelector((state: any) => state.sidebar.isOpen);
    const navigate = useNavigate();
    const location = useLocation();
    const currentPath = location.pathname.split("/");
    const sourcePage = currentPath[1] || "user-list";

    const dispatch = useAppDispatch();
    const { loading, postData, data } = useApiPost();
    const storeupdateslicevalues = useAppSelector((state) => state.storeSliceUpdate);

    const id = sessionStorage.getItem("updateserviceid");

    // API call to fetch store data
    useEffect(() => {
        if (id) {
            const formData = new FormData();
            formData.append("store_id", id);
            postData("/update-store", formData);
        }
    }, [id]);

    // Update Redux store when API response comes
    useEffect(() => {
        if (data?.store) {
            dispatch(setStore(data.store));
        }
    }, [data?.store]);

    // Update form fields when Redux store is updated
    const [formData, setFormData] = useState({
        serviceName: '',
        price: '',
    });

    useEffect(() => {
        setFormData({
            serviceName: storeupdateslicevalues.store_name || '',
            price: storeupdateslicevalues.price || '',
        });
    }, [storeupdateslicevalues]);

    const handleChange = (e: React.ChangeEvent<HTMLInputElement | HTMLTextAreaElement>) => {
        const { name, value } = e.target;
        setFormData((prev) => ({ ...prev, [name]: value }));
    };



    //   update the service values 

    const selectedCategory = useAppSelector((state) => state.UpdateSelectedStoreIDSlice.selectedCategory);
    const service_description = useAppSelector((state) => state.storeSliceUpdate.store_description);
    const coverImages = useAppSelector((state) => state.UploadAddserviceImageSlice.cover_images);
    const Attachmentimage = useAppSelector((state) => state.UploadServiceAttactmentSlice.cover_image);
    const selectedCategories = useAppSelector((state) => state.UpdateSelectedStoreIDSlice.selectedCategories);

    const storeIds = selectedCategories.map((store) => store.id).join(',');



    const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';


    const handalsubmit = async () => {


        if (IS_DEMO) {
            toast.error("This action is disabled in the demo version.");
            return;
        }
        const payload = new FormData();
        payload.append("store_id", id || "");
        payload.append("store_description", service_description)
        // payload.append("service_id", selectedCategory?.id)
        payload.append("store_name", formData.serviceName)
        payload.append("price", formData.price)
        payload.append("service_id", storeIds)


        if (coverImages && Attachmentimage) payload.append("store_attachments[]", Attachmentimage);
        coverImages.forEach((file: File) => {
            payload.append('store_images[]', file);
        });

        try {
            const response = await postData("/update-store", payload, "multipart/form-data");
            console.log("Update successful:", response);
            toast.success("Update successful")
            navigate("/service-list")
        } catch (err) {
            console.error("Update failed:", err);
        }
    };



    return (
        <div className={`bg-primary ${isSidebarOpen ? "xl:pl-20" : "xl:pl-72"}`}>
            <SearchBar />
            <div className="px-4  xl:px-6">
                <div className="w-full flex justify-between items-center gap-2">
                    {/* Left Content */}
                    <div className="flex flex-col">
                        {/* Header */}
                        <div className="flex justify-between border-t-[#F2F2F2] py-3">
                            <h2 className="text-textcolor font-poppins text-xl font-semibold pt-3">
                                Update Service
                            </h2>
                        </div>

                        {/* Breadcrumb */}
                        <div className="mb-4 flex items-center gap-2">
                            <Link to="/dashboard">
                                <h3 className="text-base font-semibold text-[#3A3A3A] font-poppins">
                                    Dashboard
                                </h3>
                            </Link>
                            <div className="h-1 w-1 rounded-full bg-[#E0E0E0]"></div>
                            <h3 className="text-base text-[#858585] font-poppins">Update Service</h3>
                        </div>
                    </div>

                    {/* Back Button */}
                    <button
                        onClick={() => navigate(-1)} // go back
                        className="flex items-center gap-2 px-4 py-[6px] text-white cursor-pointer bggradient font-poppins rounded-md"
                    >
                        <MdArrowBack size={20} />
                        Back
                    </button>
                </div>
            </div>

            {/* Main Form */}
            <div className="mx-auto w-[97%] border border-bordercolor mt-12 rounded-lg p-4">
                <div className="w-full grid   md:grid-cols-2 xl:grid-cols-3 gap-4">
                    <FormGlobalInputAnalytical
                        label="Service Name"
                        name="serviceName"
                        value={formData.serviceName}
                        onChange={handleChange}
                        required
                        placeholder="Enter Service Name"
                    />

                    <FormGlobalInputAnalytical
                        label="Service Price"
                        name="price"
                        value={formData.price}
                        onChange={handleChange}
                        required
                        placeholder="Enter Service Price"
                    />

                    <UpdateServiceStore />
                </div>


                <div className=" w-full">
                    {/* <UpdateServiceDecsription /> */}
                    <UpdateSerivceTextEdit />
                </div>

                <div className=" w-full  grid   md:grid-cols-2  mt-6 gap-4">
                    <UpdatesericeImage />
                    <UpdateServiceAttachment />
                </div>
                <div className="w-full flex   mt-6 justify-center items-center">
                    <button
                        className="w-fit px-[3rem] py-2 bggradient rounded-lg cursor-pointer font-poppins text-white"
                        disabled={loading}
                        onClick={handalsubmit}
                    >
                        {loading ? "Updating..." : "Update"}
                    </button>
                </div>
            </div>

        </div>
    );
}

export default ServiceUpdate;
