import React, { useRef, useState, useEffect } from "react";
import crossicon from "../../assets/Images/cross.png";
import uploadicon from "../../assets/Images/upload.png";
import pdficon from "../../assets/Images/pdficon.png";
import wordicon from "../../assets/Images/pdficon.png";
import fileicon from "../../assets/Images/pdficon.png";
import Cookies from "js-cookie";
import { useDispatch } from "react-redux";
import toast from "react-hot-toast";
import { useAppSelector } from "../../Hooks/Hooks";
import { clearCoverImageatc, updateAddserviceAttactmentImage } from "../../Appstore/Slice/UploadServiceAttactmentSlice";
import useApiPost from "../../Hooks/PostData";
import { setTrue } from "../../Appstore/Slice/toggleSlice";

function UpdateServiceAttachment() {
    const dispatch = useDispatch();
    const fileInputRef = useRef<HTMLInputElement>(null);

    const storeAttachment = useAppSelector((state) => state.storeSliceUpdate?.storeAttachments?.[0]?.store_attachments);
    const uploadedFile = useAppSelector((state) => state.UploadServiceAttactmentSlice.cover_image);


    const storeAttachmentID = useAppSelector((state) => state.storeSliceUpdate.storeAttachments?.[0]?.id)

    console.log(" my values and ID", storeAttachmentID)


    const [fileName, setFileName] = useState<string | null>(null);
    const [fileIcon, setFileIcon] = useState<string | null>(null);
    const [hasNewFile, setHasNewFile] = useState(false); // Track if user selected new file

    const getFileIconByExtension = (ext: string) => {
        switch (ext) {
            case "pdf":
                return pdficon;
            case "doc":
            case "docx":
                return wordicon;
            default:
                return fileicon;
        }
    };

    useEffect(() => {
        if (uploadedFile) {
            const ext = uploadedFile.name.split(".").pop()?.toLowerCase() || "";
            setFileName(uploadedFile.name);
            setFileIcon(getFileIconByExtension(ext));
            setHasNewFile(true);
        } else {
            setFileName(null);
            setFileIcon(null);
            setHasNewFile(false);
        }
    }, [uploadedFile]);

    const handleFileClick = () => {
        fileInputRef.current?.click();
    };

    const handleFileChange = (e: React.ChangeEvent<HTMLInputElement>) => {
        const files = e.target.files;
        if (!files || files.length === 0) return;

        const file = files[0];
        const allowedTypes = [
            "application/pdf",
            "application/msword",
            "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
            "text/plain",
            "application/vnd.ms-excel",
            "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
            "application/vnd.ms-powerpoint",
            "application/vnd.openxmlformats-officedocument.presentationml.presentation"
        ];

        if (!allowedTypes.includes(file.type)) {
            toast.error("Only document files are allowed (PDF, DOC, XLS, PPT, etc).");
            return;
        }

        dispatch(updateAddserviceAttactmentImage(file));
        e.target.value = ""; // Reset input to allow re-selection of same file
    };


    const { postData } = useApiPost();
  const id = sessionStorage.getItem("updateserviceid");

    const handleRemoveFile = async () => {
      
        const user_id = Cookies.get("token");

        if (!id || !user_id) {
            console.error("Missing ID or token");
            return;
        }

        const formData = new FormData();
        formData.append("store_id", id);
        formData.append("user_id", user_id);
        formData.append("store_attachment_id", storeAttachmentID.toString());

        try {
            const response = await postData(
                "/delete-storeattachment",
                formData,
                "multipart/form-data"
            );

            console.log("Attachment deleted:", response);
            toast.success("Attachment removed successfully");

            // Clear uploaded file from Redux
            dispatch(clearCoverImageatc());
            dispatch(setTrue())

            // Optional: reload store data or dispatch an update to remove old `storeAttachment` from state
            // This depends on how `storeAttachment` is managed (e.g. via API fetch or Redux update)

        } catch (err) {
            console.error("Error deleting attachment:", err);
            toast.error("Failed to delete attachment");
        }
    };




    const isapicall = useAppSelector((state) => state.toggle.value)


    useEffect(() => {
        if (isapicall) {
            const payload = new FormData()
            payload.append("store_id", id)
            postData("/update-store", payload)
        }

    }, [isapicall])


    return (
        <div className="overflow-hidden h-fit">
            <label className="font-poppins text-sm font-medium text-textcolor">
                Service Attachment
            </label>

            {/* Upload Box */}
            <div
                className="font-poppins mt-2 flex h-[2.8rem] w-full border border-bordercolor cursor-pointer items-center justify-center rounded-lg p-3 borderinputbox"
                onClick={handleFileClick}
            >
                <input
                    type="file"
                    accept=".pdf,.doc,.docx,.txt,.xls,.xlsx,.ppt,.pptx,.odt"
                    ref={fileInputRef}
                    onChange={handleFileChange}
                    className="hidden"
                />
                <div className="flex w-full gap-3 items-center justify-center">
                    <img src={uploadicon} alt="upload icon" className="h-4 w-4 object-cover" />
                    <p className="font-poppins text-[#B4B4B4] font-medium text-sm text-center">
                        Drop your file here or click to browse (documents only)
                    </p>
                </div>
            </div>

            {/* Preview */}
            {(fileName || storeAttachment) && (
                <div className="w-full h-fit mt-4 pt-2 flex items-center gap-4">
                    <img
                        src={fileIcon || getFileIconByExtension(storeAttachment?.split('.').pop() || '')}
                        alt="file icon"
                        className="w-[50px] h-[50px] object-contain rounded-md"
                    />

                    <div className="flex  gap-2">
                        <p className="font-poppins text-sm text-gray-700 break-all">
                            {fileName || storeAttachment?.split('/').pop()}
                        </p>
                        {!hasNewFile && storeAttachment && (
                            <a
                                href={storeAttachment}
                                target="_blank"
                                rel="noopener noreferrer"
                                className="text-blue-600 text-xs underline"
                            >
                                View Existing File
                            </a>
                        )}

                        <button
                            type="button"
                            className="flex h-6  w-6 items-center justify-center cursor-pointer rounded-full bg-[#BABABA]"
                            onClick={handleRemoveFile}
                        >
                            <img src={crossicon} alt="Remove" className="h-4 w-4 object-cover" />
                        </button>
                    </div>


                </div>
            )}
        </div>
    );
}

export default UpdateServiceAttachment;
