import React, { useRef, useState, useEffect } from "react";
import crossicon from "../../assets/Images/cross.png";
import uploadicon from "../../assets/Images/upload.png";
import { useDispatch } from "react-redux";
import toast from "react-hot-toast";
import { useAppSelector } from "../../Hooks/Hooks";
import {
    updateAddserviceImages,
    removeCoverImageByIndex,
} from "../../Appstore/Slice/UploadAddserviceImageSlice";
import Apimethod from "../../Hooks/Apimethod";
import { reset, setTrue } from "../../Appstore/Slice/toggleSlice";
import useApiPost from "../../Hooks/PostData";
import { setStore } from "../../Appstore/Slice/storeSliceUpdate";

function UpdatesericeImage() {
    const UpdatesericeImageslicevalues = useAppSelector((state) => state.storeSliceUpdate);

    console.log("UpdatesericeImageslicevalues##", UpdatesericeImageslicevalues.storeImages)

    const coverImages = useAppSelector((state) => state.UploadAddserviceImageSlice.cover_images);
    const dispatch = useDispatch();
    const fileInputRef = useRef<HTMLInputElement>(null);
    const [previewImages, setPreviewImages] = useState<string[]>([]);


    const { makeRequest } = Apimethod()


    useEffect(() => {
        const urls = coverImages.map((file) => URL.createObjectURL(file));
        setPreviewImages(urls);

        return () => {
            urls.forEach((url) => URL.revokeObjectURL(url));
        };
    }, [coverImages]);

    const handleFileClick = () => {
        fileInputRef.current?.click();
    };

    const handleFileChange = (e: React.ChangeEvent<HTMLInputElement>) => {
        const files = e.target.files;
        if (!files || files.length === 0) return;

        const validImages = Array.from(files).filter((file) =>
            file.type.startsWith("image/")
        );

        if (validImages.length !== files.length) {
            toast.error("Only image files are allowed.");
            return;
        }
        dispatch(updateAddserviceImages(validImages));
    };


    const id = sessionStorage.getItem("updateserviceid");


    const handleRemoveFile = async (index: number) => {
        console.log("postDatamonusonu", index)
        dispatch(reset())
        const payload = new FormData()
        payload.append("store_id", id ? id.toString() : "")
        payload.append("store_image_id", index.toString())
        let res = await makeRequest("/remove-storeimages", payload, "multipart/form-data", "POST");
        console.log("resresresres", res)
        if (res?.success == true) {
            dispatch(setTrue())
        }
    };

    const { loading, postData, data } = useApiPost()


    const isapicall = useAppSelector((state) => state.toggle.value)


    useEffect(() => {
        if (isapicall) {
            const payload = new FormData()
            payload.append("store_id", String(UpdatesericeImageslicevalues.id ?? ""))
            postData("/update-store", payload)
        }

    }, [isapicall])


    useEffect(() => {
        if (data?.status && data?.store) {
            dispatch(setStore(data?.store))
        }
    }, [data, dispatch])

    const handleRemoveFileLocal = (index: number) => {
        dispatch(removeCoverImageByIndex(index));
    };


    return (
        <div className="overflow-hidden h-fit">
            <div>
                <label className="font-poppins text-sm font-medium text-textcolor">
                    Service Images
                    <span className="text-[#F21818] pl-[1px]">*</span>
                </label>

                <div
                    className="font-poppins mt-2 flex h-[2.8rem] w-full border border-bordercolor cursor-pointer items-center justify-center rounded-lg p-3 borderinputbox"
                    onClick={handleFileClick}
                >
                    <input
                        type="file"
                        accept="image/*"
                        multiple
                        ref={fileInputRef}
                        onChange={handleFileChange}
                        className="hidden"
                    />
                    <div className="flex w-full gap-3 items-center justify-center">
                        <img src={uploadicon} alt="upload icon" className="h-4 w-4 object-cover" />
                        <p className="font-poppins text-[#B4B4B4] font-medium text-sm text-center">
                            Drop your images here or click to browse(multiple image)
                        </p>
                    </div>
                </div>


                <div className="mt-4 grid grid-cols-6 gap-2">
                    {/* API Images */}
                    {UpdatesericeImageslicevalues.storeImages?.length > 0 &&
                        UpdatesericeImageslicevalues.storeImages.map((img, index) => (
                            <div key={`api-${index}`} className="relative flex items-center justify-center">
                                <div className="relative">
                                    <img
                                        src={img.store_images}
                                        alt={`Uploaded preview ${index}`}
                                        className="uploadimageborder rounded-md object-cover w-[80px] h-[80px]"
                                    />
                                    <button
                                        type="button"
                                        className="absolute right-[-0.2rem] top-0"
                                        onClick={() => handleRemoveFile(img.id)}
                                    >
                                        <div className="flex h-6 w-6 items-center  cursor-pointer justify-center rounded-full bg-[#BABABA]">
                                            <img src={crossicon} alt="cross icon" className="h-4 w-4 object-cover" />
                                        </div>
                                    </button>
                                </div>
                            </div>
                        ))}

                    {/* Local Preview Images */}
                    {previewImages.length > 0 &&
                        previewImages.map((img, index) => (
                            <div key={`local-${index}`} className="relative flex items-center justify-center">
                                <div className="relative">
                                    <img
                                        src={img}
                                        alt={`Preview ${index}`}
                                        className="uploadimageborder rounded-md object-cover w-[80px] h-[80px]"
                                    />
                                    <button
                                        type="button"
                                        className="absolute right-[-0.2rem] top-0"
                                        onClick={() => handleRemoveFileLocal(index)}
                                    >
                                        <div className="flex h-6 w-6 items-center  cursor-pointer justify-center rounded-full bg-[#BABABA]">
                                            <img src={crossicon} alt="cross icon" className="h-4 w-4 object-cover" />
                                        </div>
                                    </button>
                                </div>
                            </div>
                        ))}
                </div>

            </div>
        </div>
    );
}

export default UpdatesericeImage;
