import { useState, useEffect, useMemo, useCallback } from "react";
import toast from "react-hot-toast";
import useApiPost from "../../Hooks/PostData";
import { useAppDispatch } from "../../Hooks/Hooks";
import InputField from "../../Componets/InputField";
import { useGetDataWithToken } from "../../Appstore/Api/UsegetRefundpolicy";

function Distance() {
    const { data, isLoading , refetch } = useGetDataWithToken("/nearby-distance", ["nearby-distance"]);


    console.log("gfdgsfdgggfds", data?.data)

    const { loading, error, postData } = useApiPost();
    const dispatch = useAppDispatch();

    const [initialData, setInitialData] = useState(null);
    const [formData, setFormData] = useState({
        distance: "",
        distance_type: "",
      
    });


        const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';


    const [isEdited, setIsEdited] = useState(false);

    useEffect(() => {
        if (data?.data) {
            const {
                distance,
                distance_type,
              
            } = data.data;

            const defaultForm = {
                distance: distance || "",
                distance_type: distance_type || "",
               
            };

            setFormData(defaultForm);
            setInitialData(defaultForm);
        }
    }, [data]);

    const handleChange = useCallback((field: string, value: string) => {
        setFormData((prev) => ({ ...prev, [field]: value }));
        setIsEdited(true);
    }, []);

    const isFormEdited = useMemo(() => {
        if (!initialData) return false;

        return Object.keys(formData).some(
            (key) => formData[key] !== initialData[key]
        );
    }, [formData, initialData]);

    useEffect(() => {
        setIsEdited(isFormEdited);
    }, [isFormEdited]);

    const handleSubmit = async () => {

           if (IS_DEMO) {
            toast.error("This action is disabled in the demo version.");
            return;
        }
        if (!isEdited) return;

        const formPayload = new FormData();
        Object.entries(formData).forEach(([key, value]) => {
            formPayload.append(key, value);
        });

        try {
            await postData("/nearby-distance", formPayload, "multipart/form-data");
            toast.success("Settings updated successfully!");
            setIsEdited(false);
            refetch();
        } catch (err) {
            toast.error(err?.response?.data?.message || "Failed to update settings");
        }
    };

    return (
        <>
            <h2 className="text-textcolor font-semibold font-poppins text-xl pb-4">Distance</h2>
            <div className="border border-bordercolor bg-primary rounded-lg p-4 mt-5 md:mt-0">
                <div className="grid  md:grid-cols-2 gap-4 pb-5">
                    <InputField
                        label="Distance"
                        value={formData.distance}
                        placeholder="Enter Distance"
                        onChange={(e) => handleChange("distance", e.target.value)}
                    />

                      <InputField
                        label="Distance Type"
                        value={formData.distance_type}
                        placeholder="Enter Distance Type"
                    />


                </div>

                <div className="flex justify-center py-6 place-items-center">
                    <button
                        onClick={handleSubmit}
                        disabled={!isEdited}
                        className={`px-24 py-3 font-medium text-white rounded-xl  ${isEdited ? "bggradient cursor-pointer" : "bggradient opacity-50 cursor-not-allowed"
                            }`}
                    >
                        {loading ? "Submitting..." : "Submit"}
                    </button>
                </div>
            </div>
        </>
    );
}

export default Distance;  
