import React, { useState, useEffect } from "react";

import Stripe from "./Stripe";
import Gpay from "./Gpay";
import Applepay from "./Applepay";
import Paypal from "./Paypal";
import { useSelector } from "react-redux";
import SearchBar from "../../../Componets/SearchBar/SearchBar";
import { Link } from "react-router-dom";
import { UsegetPaymentSetting } from "../../../Appstore/Api/UsegetPaymentSetting";
import { useAppDispatch, useAppSelector } from "../../../Hooks/Hooks";
import { setAppConfig } from "../../../Appstore/Slice/appConfigSlice";
import RazorPay from "./RazorPay";
import Flutterwave from "./Flutterwave";


function Payment() {

    const isSidebarOpen = useSelector((state: any) => state.sidebar.isOpen);


    const [option, setOption] = useState("Stripe");


    const { data } = UsegetPaymentSetting()


    console.log(" my payment setting  values", data?.all_payment)

    const dispatch = useAppDispatch()

    useEffect(() => {
        if (data && data.all_payment) {
            dispatch(setAppConfig(data));
        }
    }, [data, dispatch]);






    const apirespo = useAppSelector((state) => state.appConfig.config?.all_payment)

    console.log("my slice values  from the api responce ", apirespo)



    return (
        <>
            <div className={`bg-primary ${isSidebarOpen ? 'xl:pl-20' : 'xl:pl-72'}`}>
                <SearchBar />

                <div className="px-4 pb-10 xl:px-6">
                    {/* Header */}
                    <div className="flex justify-between border-t-[#F2F2F2] py-3">
                        <h2 className="text-textcolor font-poppins text-xl font-semibold pt-3 ">
                            Payment Method
                        </h2>

                    </div>

                    {/* Breadcrumb */}
                    <div className="mb-4 flex items-center gap-2">
                        <Link to="/dashboard">
                            <h3 className="text-base font-semibold text-[#3A3A3A]  font-poppins">Dashboard</h3>
                        </Link>
                        <div className="h-1 w-1 rounded-full bg-[#E0E0E0]"></div>
                        <h3 className="text-base text-[#858585] font-poppins">Payment Method</h3>
                    </div>
                    <h2 className="text-textcolor font-semibold font-poppins text-xl pb-4">Payment Configuration</h2>

                    <div className="mt-5 border rounded-lg border-bordercolor md:mt-0">
                        <div className="grid  grid-cols-2 md:grid-cols-3 2xl:grid-cols-6">

                            <button
                                className={`font-poppins font-semibold w-full py-3 border-b  cursor-pointer border-bordercolor rounded-tl-lg text-sm ${option === "RazorPay" ? "text-[#FFFFFF]  bggradient" : " text-[#5B5B5B]"}`}
                                onClick={() => setOption("RazorPay")}
                            >
                              Razorpay
                            </button>

                            <button
                                className={`font-poppins font-semibold w-full py-3 border-b  cursor-pointer border-bordercolor rounded-tl-lg text-sm ${option === "Flutterwave" ? "text-[#FFFFFF]  bggradient" : " text-[#5B5B5B]"}`}
                                onClick={() => setOption("Flutterwave")}
                            >
                               Flutterwave
                            </button>

                            {/* Stripe */}
                            <button
                                className={`font-poppins font-semibold w-full py-3 border-b  cursor-pointer border-bordercolor rounded-tl-lg text-sm ${option === "Stripe" ? "text-[#FFFFFF]  bggradient" : " text-[#5B5B5B]"}`}
                                onClick={() => setOption("Stripe")}
                            >
                                Stripe
                            </button>

                            {/* gpay*/}
                            <button
                                className={`font-poppins font-semibold border-b  border-bordercolor cursor-pointer w-full py-3 rounded-tl-lg text-sm ${option === "gpay" ? "text-[#FFFFFF] bggradient" : " text-[#5B5B5B]"}`}
                                onClick={() => setOption("gpay")}
                            >
                              Google Pay
                            </button>

                            {/* apple_pay*/}
                            <button
                                className={`font-poppins font-semibold border-b  border-bordercolor cursor-pointer w-full py-3 rounded-tl-lg text-sm ${option === "apple_pay" ? "text-[#FFFFFF] bggradient" : " text-[#5B5B5B]"}`}
                                onClick={() => setOption("apple_pay")}
                            >
                               Apple Pay
                            </button>

                            {/*paypal*/}
                            <button
                                className={`font-poppins font-semibold border-b  border-bordercolor cursor-pointer w-full py-3 rounded-tl-lg text-sm ${option === "paypal" ? "text-[#FFFFFF] bggradient" : " text-[#5B5B5B]"}`}
                                onClick={() => setOption("paypal")}
                            >
                                Paypal
                            </button>

                        </div>

                        {/* Twilio */}
                        {option === "Stripe" && (
                            <Stripe />
                        )}

                        {option === "gpay" && (
                            <Gpay />
                        )}


                        {option === "apple_pay" && (
                            <Applepay />
                        )}

                        {option === "paypal" && (
                            <Paypal />
                        )}


                        {option === "RazorPay" && (
                            <RazorPay />
                        )}


                        {option === "Flutterwave" && (
                            <Flutterwave />
                        )}
                    </div>
                </div>
            </div>
        </>
    );
}

export default Payment;
