import toast from "react-hot-toast";
import { UseGetGeneralSetting } from "../../Appstore/Api/UseGetGeneralSetting";
import { showModal } from "../../Appstore/Slice/ModalSlice";
import { useAppDispatch, useAppSelector } from "../../Hooks/Hooks";

function PurchaseCode() {

    const { data, isLoading, refetch } = UseGetGeneralSetting();
    const purchaseCode = data?.data?.purchase_code
    const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';


    const dispatch = useAppDispatch()
    return (
        <>
            <div className="border border-bordercolor  rounded-lg px-8 py-6 mt-5 md:mt-0">
                <p className="text-textcolor font-semibold text-base pb-2 ">Purchase Code</p>
                <input
                    type="password"
                    value={purchaseCode}
                    readOnly
                    className="border border-bordercolor font-poppins text-textcolor  bg-transparent rounded-md w-full py-3 my-1 px-4 placeholder:font-gilroy_regular placeholder:text-sm placeholder:text-textcolor placeholder:opacity-50  focus:outline-none focus:ring-1 focus:ring-[#0046AE]"
                />

                <div className="flex justify-center pt-14 place-items-center">
                    <button className="px-24 py-3 font-medium text-white rounded-xl  cursor-pointer bg-[#FF3838]" onClick={() => {

                        if (IS_DEMO) {
                            toast.error("This action is disabled in the demo version.");
                            return;
                        }
                        dispatch(showModal("DeleteToken"))
                    }} >Deactive</button>
                </div>
            </div>
        </>
    );
}

export default PurchaseCode;
