import { useState, useEffect, useMemo, useCallback } from "react";
import toast from "react-hot-toast";
import useApiPost from "../../Hooks/PostData";
import { useAppDispatch } from "../../Hooks/Hooks";
import { UsePhoneSetupSetting } from "../../Appstore/Api/UsePhoneSetupSetting";
import InputField from "../../Componets/InputField";

function SMSConfiguration() {
  const { data, isLoading, refetch } = UsePhoneSetupSetting();
  const { loading, error, postData } = useApiPost();
  const dispatch = useAppDispatch();



      const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';

  const [initialData, setInitialData] = useState(null);
  const [formData, setFormData] = useState({
    android_url: "",
    android_provider_url: "",
    ios_url: "",
    ios_provider_url: ""
  });

  const [isEdited, setIsEdited] = useState(false);

  useEffect(() => {
    if (data?.data) {
      const {
        android_url,
        android_provider_url,
        ios_url,
        ios_provider_url
      } = data.data;

      const defaultForm = {
        android_url: android_url || "",
        android_provider_url: android_provider_url || "",
        ios_url: ios_url || "",
        ios_provider_url: ios_provider_url || ""
      };

      setFormData(defaultForm);
      setInitialData(defaultForm);
    }
  }, [data]);

  const handleChange = useCallback((field: string, value: string) => {
    setFormData((prev) => ({ ...prev, [field]: value }));
    setIsEdited(true);
  }, []);

  const isFormEdited = useMemo(() => {
    if (!initialData) return false;

    return Object.keys(formData).some(
      (key) => formData[key] !== initialData[key]
    );
  }, [formData, initialData]);

  useEffect(() => {
    setIsEdited(isFormEdited);
  }, [isFormEdited]);

  const handleSubmit = async () => {
       if (IS_DEMO) {
            toast.error("This action is disabled in the demo version.");
            return;
        }
    if (!isEdited) return;

    const formPayload = new FormData();
    Object.entries(formData).forEach(([key, value]) => {
      formPayload.append(key, value);
    });

    try {
      await postData("/mobile-setup", formPayload, "multipart/form-data");
      toast.success("Settings updated successfully!");
      setIsEdited(false);
      refetch();
    } catch (err) {
      toast.error(err?.response?.data?.message || "Failed to update settings");
    }
  };

  return (
    <>
      <h2 className="text-textcolor font-semibold font-poppins text-xl pb-4">Mobile App URLs</h2>
      <div className="border border-bordercolor bg-primary rounded-lg p-4 mt-5 md:mt-0">
        <div className="grid gap-4 pb-5 md:grid-cols-2">
          <InputField
            label="Android Play Store URL"
            value={formData.android_url}
            placeholder="Enter Android Play Store URL"
            onChange={(e) => handleChange("android_url", e.target.value)}
            
          />
          {/* <InputField
            label="Android Play Store Provider URL"
            value={formData.android_provider_url}
            placeholder="Enter Android Provider URL"
            onChange={(e) => handleChange("android_provider_url", e.target.value)}
          /> */}
          <InputField
            label="iOS App Store URL"
            value={formData.ios_url}
            placeholder="Enter iOS App Store URL"
            onChange={(e) => handleChange("ios_url", e.target.value)}
          />
          {/* <InputField
            label="iOS App Store Provider URL"
            value={formData.ios_provider_url}
            placeholder="Enter iOS Provider URL"
            onChange={(e) => handleChange("ios_provider_url", e.target.value)}
          /> */}
        </div>

        <div className="flex justify-center py-6 place-items-center">
          <button
            onClick={handleSubmit}
            disabled={!isEdited}
            className={`px-24 py-3 font-medium text-white  cursor-pointer rounded-xl ${isEdited ? "bggradient" : "bggradient opacity-50 cursor-not-allowed"
              }`}
          >
            {loading ? "Submitting..." : "Submit"}
          </button>
        </div>
      </div>
    </>
  );
}

export default SMSConfiguration;
