import React, { useEffect, useState } from "react";
import Background from "../../assets/Images/installbgimage.png";
import Logo from "../../assets/Images/logo.png";
import LightVector from "../../assets/Images/LightVector.png";
import InfoCircle from "../../assets/Images/info.png";
import LightStroke from "../../assets/Images/LightStroke.png";
import axios from "axios";
import { useNavigate } from "react-router-dom";
import toast from "react-hot-toast";
import Cookies from "js-cookie";
import { ClipLoader } from "react-spinners";


function Page2() {

  const [username, setUsername] = useState("");
  const [purchaseCode, setPurchaseCode] = useState("");
  const [isValid, setIsValid] = useState(false);
  const [errorShown, setErrorShown] = useState(false);
  const [wasEdited, setWasEdited] = useState(false);
  const [isLoading, setIsLoading] = useState(false);

  const navigate = useNavigate();

  useEffect(() => {
    if (!username || !purchaseCode || !wasEdited) return;

    const debounceTimeout = setTimeout(() => {
      const validatePurchaseInfo = async () => {
        setIsLoading(true);
        try {
          const response = await axios.post(
            `${import.meta.env.VITE_API_URL}/validate-purchase`,
            {
              username,
              purchase_code: purchaseCode,
            }
          );

          if (response.data?.message === "Validation successful!") {
            setIsValid(true);
            Cookies.set("PurchaseToken", response.data?.token);
            toast.success("Validation successful!");
            setWasEdited(false);
            setErrorShown(false);
          } else {
            setIsValid(false);
            if (!errorShown) {
              toast.error(
                response.data?.error || "Invalid purchase information"
              );
              setErrorShown(true);
              setWasEdited(false);
            }
          }
        } catch (error) {
          setIsValid(false);
          const errorMessage =
            error.response?.data?.error ||
            "Something went wrong during validation";
          if (!errorShown) {
            toast.error(errorMessage);
            setErrorShown(true);
            setWasEdited(false);
          }
        } finally {
          setIsLoading(false)
        }
      };

      validatePurchaseInfo();
    }, 1000);

    return () => clearTimeout(debounceTimeout); // Cleanup timeout on input change
  }, [username, purchaseCode, wasEdited]);

  console.log("Response !!!2324", purchaseCode);

  const handleStorePurchaseCode = () => {
    localStorage.setItem("Puchase_Code", purchaseCode);
    sessionStorage.setItem("show_varification_steps", true);
    navigate("/nlytical-install-3");
  };

  return (
    <>
      <div className="relative w-full h-screen">
        {/* Background Image */}
        <img
          src={Background}
          alt="Background"
          className="object-cover w-full h-full"
        />

        {/* Overlay Content */}
        <div className="absolute inset-0 flex flex-col">
          {/* Top Right Logo and Snapta */}
          <div className="flex justify-center p-8  sm:justify-end xl:mr-[4rem]">
            <div className="flex items-center gap-3">
              <img src={Logo} alt="Logo" className=" w-[10rem]" />
            </div>
          </div>

          {/* Center Title */}
          <div className="justify-center">
            <h2 className="text-[#000000] sm:text-4xl text-xl font-semibold font-poppins text-center">Nlytical App Software Installation</h2>
            <p className="text-[#000000] font-poppins sm:text-base text-center pt-2">Please make sure the PHP extensions listed below are installed</p>
          </div>

          {/* No. of Steps */}
          <div className="flex justify-center py-3 sm:gap-3 place-items-center">
            <button
              className={`rounded-full px-5 py-2 bggradient text-[#FFFFFF] font-poppins`}
            >
              1
            </button>
            <img src={LightVector} className="w-16" />
            <button
              className={`rounded-full px-4 py-2 bggradient text-[#FFFFFF] font-poppins`}
            >
              2
            </button>
            <img src={LightVector} className="w-16" />
            <button
              className={`rounded-full px-4 py-2 text-[#000000]  bg-[#0046AE1F] font-poppins`}
            >
              3
            </button>
            <img src={LightStroke} className="w-16" />
            <button
              className={`rounded-full px-4 py-2 text-[#000000]  bg-[#0046AE1F] font-poppins`}
            >
              4
            </button>

          </div>

          {/* Centered Div */}
          <div className="flex justify-center w-full py-6">
            <div
              className="bg-[#FFFFFF] w-[950px] rounded-md sm:p-6 p-4"
              style={{ boxShadow: "8px 9px 55.9px 0px #00000033" }}
            >
              <div className="justify-between sm:flex">
                <h2 className="font-poppins text-[#000000] text-base flex flex-row">
                  Step 2 :
                  <div className="flex flex-col">
                    <span className="font-poppins text-[#555555] text-base pl-1">
                      Update Purchase Information
                    </span>
                    <span className="hidden pl-1 text-sm text-red-500 sm:block font-poppins">
                      Provide your{" "}
                      <span className="font-semibold text-red-500 font-poppins">
                        username of codecayon
                      </span>{" "}
                      & purchase the code
                    </span>
                  </div>
                </h2>
                <span className="text-[#000000] text-sm sm:hidden block font-poppins">
                  Provide your{" "}
                  <span className="font-semibold text-red-500 font-poppins">
                    username of codecayon
                  </span>{" "}
                  & purchase the code
                </span>

                <div className="flex gap-1 place-items-center">
                  <a
                    target="_blank"
                    href="https://document.snapta.online/"
                    className="font-poppins text-[#435CFF] underline text-xs cursor-pointer"
                  >
                    Read documentation
                  </a>
                  <img src={InfoCircle} className="w-3 h-3" />
                </div>
              </div>

              {/* Username and purchase code */}
              <div
                className="p-4 my-6 rounded-md sm:p-6 sm:mx-12"
                style={{ boxShadow: "8px 9px 55.9px 0px #00000033" }}
              >
                <div className="gap-4 sm:flex">
                  {/* Username */}
                  <div className="sm:w-[50%] relative inline-block">
                    <div className="relative flex gap-1 pb-2 place-items-center">
                      <label className="font-poppins text-sm text-[#000000] font-semibold">
                        Username
                        <span className="text-red-500 font-poppins">*</span>
                      </label>
                      {/* Toggleable Info Tooltip */}
                      <div className="relative inline-block group">
                        <img
                          src={InfoCircle}
                          className="w-3 h-3 cursor-pointer"
                          alt="info"
                        />
                        {/* Tooltip container (shown on hover) */}
                        <div className="absolute z-10 hidden mt-2 group-hover:block">
                          {/* Arrow */}
                          <div className="w-2 h-2 rotate-45 bg-[#EFEFEF] -mb-1"></div>

                          {/* Tooltip box */}
                          <div className="bg-[#EFEFEF] p-2 flex items-center gap-2 border w-max border-[#EFEFEF] rounded shadow-lg">
                            <p className="font-poppins text-[#000000] text-xs">
                              Please enter Envato username here
                            </p>
                          </div>
                        </div>
                      </div>
                    </div>
                    <input
                      className="border 2xl:py-4 border-[#e5e7eb] border-opacity-10 text-sm pl-4 w-full placeholder:text-[#989898] focus:outline-none focus:ring-0 focus:border-[#0046AE] text-[#000000] py-3 font-poppins rounded-md"
                      type="text"
                      placeholder="Enter username"
                      value={username}
                      onChange={(e) => {
                        setUsername(e.target.value);
                        setWasEdited(true);
                        setErrorShown(false);
                      }}
                    />
                  </div>

                  {/* Purchase Code */}
                  <div className="sm:w-[50%] pt-4 sm:pt-0">
                    <div className="flex gap-1 pb-2 place-items-center">
                      <label className="font-poppins text-[#000000] text-sm font-semibold">
                        Purchase Code
                        <span className="text-[#A3A3A3] font-poppins text-xs font-medium">
                          {" "}
                          (You can find{" "}
                          <a target="_blank"
                            href="https://help.market.envato.com/hc/en-us/articles/202822600-Where-Is-My-Purchase-Code"
                            className="font-poppins text-xs text-[#435CFF] border-[#435CFF] border-b-[0.5px] cursor-pointer">
                            purchase code
                          </a>{" "}
                          here)
                        </span>
                        <span className="text-red-500 font-poppins">*</span>
                      </label>
                      <img src={InfoCircle} className="w-3 h-3" />
                    </div>
                    <input
                      type="text"
                      className="border 2xl:py-4 border-[#e5e7eb] border-opacity-10 text-sm pl-4 w-full placeholder:text-[#989898] focus:outline-none focus:ring-0 focus:border-[#0046AE] text-[#000000] py-3 font-poppins rounded-md"
                      placeholder="Ex:19xxxxx-case-jhdshff74Isd0000000000"
                      value={purchaseCode}
                      onChange={(e) => {
                        setPurchaseCode(e.target.value);
                        setWasEdited(true);
                        setErrorShown(false);
                      }}
                    />

                  </div>
                </div>
              </div>

              {/* Button */}
              <div className="flex justify-center py-3">
                <button
                  disabled={!isValid}
                  className={`w-[200px] py-3  cursor-pointer font-medium text-white rounded-xl ${isValid
                    ? "bggradient"
                    : "bg-[#0046AE99] cursor-not-allowed"
                    }`}
                  onClick={handleStorePurchaseCode}
                >
                  {isLoading ? (<>
                    <ClipLoader
                      loading={isLoading}
                      size={20}
                      aria-label="Loading Spinner"
                      data-testid="loader"
                      color='#FFFFFF'
                    />
                  </>) : (<>Next</>)}
                </button>
              </div>
            </div>
          </div>
          {/* Divider */}
          <div className="flex justify-center py-2">
            <div className="bg-[#CCCCCC] h-[1.5px] rounded-lg w-[950px]"></div>
          </div>

          {/* Logo */}
          <div className="sm:flex justify-between w-full max-w-[970px] mx-auto px-4 pb-4 sm:pb-0">
            <div className="flex items-center gap-2">
              <img src={Logo} alt="Logo" className="w-[8rem] h-[2.7rem]" />
            </div>

            <p className="font-poppins text-[#535353] text-sm">
              @2025 | All rights reserved by{" "}
              <a
                className="text-[#2A2A2A] underline font-semibold cursor-pointer"
                href="https://primocys.com/"
                target="_blank"
              >
                Primocys
              </a>
              .
            </p>
          </div>
        </div>
      </div>
    </>
  );
}

export default Page2;
