import React, { useEffect, useState } from "react";
import Background from "../../assets/Images/installbgimage.png";
import Logo from "../../assets/Images/logo.png";
import LightVector from "../../assets/Images/LightVector.png";
import InfoCircle from "../../assets/Images/info.png";
import LightStroke from "../../assets/Images/LightStroke.png";
import axios from "axios";
import { Link, useNavigate } from "react-router-dom";
import toast from "react-hot-toast";
import Cookies from "js-cookie";
import { ClipLoader } from "react-spinners";


function Page3() {
  const navigate = useNavigate();
  const token = Cookies.get("Snapta_Admin_Token");
  const [isEdited, setIsEdited] = useState(false);
  const [isLoading, setIsLoading] = useState(false);

  const [formData, setFormData] = useState({
    APP_URL: "",
    DB_DATABASE: "",
    DB_USERNAME: "",
    DB_PASSWORD: "",
  });

  useEffect(() => {
    const fetchSavedConfiguration = async () => {
      setIsLoading(true);
      try {
        const response = await axios.post(
          `${import.meta.env.VITE_API_URL}/save-configuration`
        );
        const config = response.data.updated_values;
        setFormData({
          APP_URL: config.APP_URL || "",
          DB_DATABASE: config.DB_DATABASE || "",
          DB_USERNAME: config.DB_USERNAME || "",
          DB_PASSWORD: config.DB_PASSWORD || "",
        });
      } catch (error) {
        console.error("Failed to fetch saved configuration:", error);
      } finally {
        setIsLoading(false);
      }
    };

    fetchSavedConfiguration();
  }, []);

  const handleNext = async () => {
    setIsLoading(true)
    try {
      const formDataToUpload = new FormData();
      formDataToUpload.append("app_url", formData.APP_URL);
      formDataToUpload.append("db_database", formData.DB_DATABASE);
      formDataToUpload.append("db_username", formData.DB_USERNAME);
      formDataToUpload.append("db_password", formData.DB_PASSWORD);

      const response = await axios.post(
        `${import.meta.env.VITE_API_URL}/save-configuration`,
        formDataToUpload,
        {
          headers: {
            "Content-Type": "multipart/form-data",
            Authorization: `Bearer ${token}`,
          },
        }
      );

      toast.success("Configuration saved successfully!");
      setIsEdited(false);
      navigate("/nlytical-install-4");
    } catch (error) {
      toast.error("Failed to save configuration.");
      console.error("Error saving configuration:", error);
    } finally {
      setIsLoading(false)
    }
  };

  const handleChange = (field, value) => {
    setFormData((prev) => ({ ...prev, [field]: value }));
    setIsEdited(true);
  };

  return (
    <>
      <div className="relative w-full h-screen">
        {/* Background Image */}
        <img
          src={Background}
          alt="Background"
          className="object-cover w-full h-full"
        />

        {/* Overlay Content */}
        <div className="absolute inset-0 flex flex-col">
          {/* Top Right Logo and Snapta */}
          <div className="flex justify-center p-8  sm:justify-end xl:mr-[4rem]">
            <div className="flex items-center gap-3">
              <img src={Logo} alt="Logo" className=" w-[10rem]" />
            </div>
          </div>

          {/* Center Title */}
          <div className="justify-center">
            <h2 className="text-[#000000] sm:text-4xl text-xl font-semibold font-poppins text-center">
              Snapta App Software Installation
            </h2>
            <p className="text-[#000000] font-poppins sm:text-base text-center pt-2">
              Please make sure the PHP extensions listed below are installed
            </p>
          </div>

          {/* No. of Steps */}
          <div className="flex justify-center py-3 sm:gap-3 place-items-center">
            <button
              className={`rounded-full px-5 py-2 bggradient text-[#FFFFFF] font-poppins`}
            >
              1
            </button>
            <img src={LightVector} className="w-16" />
            <button
              className={`rounded-full px-4 py-2 bggradient text-[#FFFFFF] font-poppins`}
            >
              2
            </button>
            <img src={LightVector} className="w-16" />
            <button
              className={`rounded-full px-4 py-2 bggradient text-[#FFFFFF] font-poppins`}
            >
              3
            </button>
            <img src={LightStroke} className="w-16" />
            <button
              className={`rounded-full px-4 py-2 text-[#000000]  bg-[#0046AE1F] font-poppins`}
            >
              4
            </button>

          </div>

          {/* Centered Div */}

          <div className="flex justify-center w-full py-6">
            <div
              className="bg-[#FFFFFF] w-[950px] rounded-md sm:p-6 p-4"
              style={{ boxShadow: "8px 9px 55.9px 0px #00000033" }}
            >
              <div className="justify-between sm:flex">
                <h2 className="font-poppins text-[#000000] text-base flex flex-row">
                  Step 3 :
                  <div className="flex flex-col">
                    <span className="font-poppins text-[#555555] text-base pl-1">
                      Update Database Information
                    </span>
                    <span className="hidden pl-1 text-sm text-red-500 sm:block xl:text-sm 2xl:text-sm font-poppins">
                      If you have entered the fields in env file then you can
                      skip this step
                    </span>
                  </div>
                </h2>
                <span className="block text-sm text-red-500 sm:hidden xl:text-sm 2xl:text-sm font-poppins sm:pl-1">
                  If you have entered the fields in env file then you can skip
                  this step
                </span>
                <div className="flex gap-1 pt-2 place-items-center sm:pt-0">
                  <a
                    target="_blank"
                    href="https://document.snapta.online/"
                    className="font-poppins text-[#435CFF] underline text-xs cursor-pointer"
                  >
                    Read documentation
                  </a>

                  <img src={InfoCircle} className="w-3 h-3" />
                </div>
              </div>

              {/* All fields */}
              {isLoading ? (<>
                <div className="flex justify-center py-24 place-items-center">
                  <ClipLoader
                    loading={isLoading}
                    size={20}
                    aria-label="Loading Spinner"
                    data-testid="loader"
                    color="#452B7A"
                  />
                </div>

              </>) : (<>
                <div
                  className="bg-[#FFFFFF] sm:mx-12 mt-10 rounded-md p-6"
                  style={{ boxShadow: "8px 9px 55.9px 0px #00000033" }}
                >
                  <div className="gap-4 sm:flex">
                    {/* Database Name */}
                    <div className="sm:w-[50%] relative inline-block">
                      <div className="relative flex gap-1 pb-2 place-items-center">
                        <label className="font-poppins text-sm text-[#000000] font-semibold">
                          Database Name
                        </label>

                        <div className="relative inline-block group">
                          <img
                            src={InfoCircle}
                            className="w-3 h-3 cursor-pointer"
                            alt="info"
                          />
                          {/* Tooltip container (shown on hover) */}

                          <div className="absolute z-10 hidden max-w-xs mt-2 group-hover:block w-max">
                            {/* Arrow */}
                            <div className="w-2 h-2 rotate-45 bg-[#EFEFEF]-mb-1"></div>

                            {/* Tooltip box */}
                            <div className="bg-[#EFEFEF] p-2 border border-[#EFEFEF] rounded shadow-lg">
                              <p className="font-poppins text-[#000000] text-xs break-words">
                                Enter the database name which you have created in
                                your phpmyadmin mysql
                              </p>
                            </div>
                          </div>
                        </div>
                      </div>
                      <input
                        value={formData.DB_DATABASE}
                        onChange={(e) =>
                          handleChange("DB_DATABASE", e.target.value)
                        }
                        placeholder="db_name"
                        type="text"
                        className="border 2xl:py-4 border-[#e5e7eb] border-opacity-10 text-sm pl-4 w-full placeholder:text-[#989898] focus:outline-none focus:ring-0 focus:border-[#0046AE] text-[#000000] py-3 font-poppins rounded-md"
                      />
                    </div>

                    {/* Database Username */}
                    <div className="sm:w-[50%] pt-4 sm:pt-0">
                      <div className="flex gap-1 pb-2 place-items-center">
                        <label className="font-poppins text-sm text-[#000000] font-semibold">
                          Database Username
                        </label>

                        <div className="relative inline-block group">
                          <img
                            src={InfoCircle}
                            className="w-3 h-3 cursor-pointer"
                            alt="info"
                          />
                          {/* Tooltip container (shown on hover) */}
                          <div className="absolute z-10 hidden mt-2 group-hover:block">
                            {/* Arrow */}
                            <div className="w-2 h-2 rotate-45 bg-[#EFEFEF]  -mb-1"></div>

                            {/* Tooltip box */}
                            <div className="bg-[#EFEFEF] p-2 flex items-center gap-2 border w-max border-[#EFEFEF] rounded shadow-lg">
                              <p className="font-poppins text-[#000000] text-xs">
                                Enter the database username you have set
                              </p>
                            </div>
                          </div>
                        </div>
                      </div>
                      <input
                        value={formData.DB_USERNAME}
                        onChange={(e) =>
                          handleChange("DB_USERNAME", e.target.value)
                        }
                        placeholder="Ex : root"
                        type="text"
                        className="border 2xl:py-4 border-[#e5e7eb] border-opacity-10 text-sm pl-4 w-full placeholder:text-[#989898] focus:outline-none focus:ring-0 focus:border-[#0046AE] text-[#000000] py-3 font-poppins rounded-md"
                      />
                    </div>
                  </div>

                  {/* Database Password */}
                  <div className="gap-4 sm:flex">
                    <div className="sm:w-[50%] pt-4">
                      <div className="flex gap-1 pb-2 place-items-center">
                        <label className="font-poppins text-sm text-[#000000] font-semibold">
                          Database Password
                        </label>

                        <div className="relative inline-block group">
                          <img
                            src={InfoCircle}
                            className="w-3 h-3 cursor-pointer"
                            alt="info"
                          />
                          {/* Tooltip container (shown on hover) */}
                          <div className="absolute z-10 hidden mt-2 group-hover:block">
                            {/* Arrow */}
                            <div className="w-2 h-2 rotate-45 bg-[#EFEFEF]  -mb-1"></div>

                            {/* Tooltip box */}
                            <div className="bg-[#EFEFEF] p-2 flex items-center gap-2 border w-max border-[#EFEFEF] rounded shadow-lg">
                              <p className="font-poppins text-[#000000] text-xs">
                                Enter the database password you have set
                              </p>
                            </div>
                          </div>
                        </div>
                      </div>
                      <input
                        value={formData.DB_PASSWORD}
                        onChange={(e) =>
                          handleChange("DB_PASSWORD", e.target.value)
                        }
                        placeholder="Ex : Password"
                        type="text"
                        className="border 2xl:py-4 border-[#e5e7eb] border-opacity-10 text-sm pl-4 w-full placeholder:text-[#989898] focus:outline-none focus:ring-0 focus:border-[#0046AE] text-[#000000] py-3 font-poppins rounded-md"
                      />
                    </div>

                    {/* Application URL */}
                    <div className="sm:w-[50%]  pt-4">
                      <div className="flex gap-1 pb-2 place-items-center">
                        <label className="font-poppins text-sm text-[#000000] font-semibold">
                          Application URL
                        </label>

                        <div className="relative inline-block group">
                          <img
                            src={InfoCircle}
                            className="w-3 h-3 cursor-pointer"
                            alt="info"
                          />
                          {/* Tooltip container (shown on hover) */}
                          <div className="absolute z-10 hidden mt-2 group-hover:block">
                            {/* Arrow */}
                            <div className="w-2 h-2 rotate-45 bg-[#EFEFEF]  -mb-1"></div>

                            {/* Tooltip box */}
                            <div className="bg-[#EFEFEF] p-2 flex items-center gap-2 border w-max border-[#EFEFEF] rounded shadow-lg">
                              <p className="font-poppins text-[#000000] text-xs">
                                Enter the domain URL
                              </p>
                            </div>
                          </div>
                        </div>
                      </div>
                      <input
                        value={formData.APP_URL}
                        onChange={(e) => handleChange("APP_URL", e.target.value)}
                        placeholder="Ex : https://yourdomain.com"
                        type="text"
                        className="border 2xl:py-4 border-[#e5e7eb] border-opacity-10 text-sm pl-4 w-full placeholder:text-[#989898] focus:outline-none focus:ring-0 focus:border-[#0046AE] text-[#000000] py-3 font-poppins rounded-md"
                      />
                    </div>
                  </div>
                </div>
              </>)}


              {/* Next button */}
              <div className="flex justify-center pt-5">
                <div className="flex gap-4">
                  {/* Skip button */}
                  <Link to="/nlytical-install-4">
                    <button
                      className={`px-20 py-3 font-medium cursor-pointer text-white rounded-xl bggradient`}
                    >
                      Skip
                    </button>
                  </Link>

                  {/* Next Button */}
                  <button
                    onClick={handleNext}
                    className={`px-20 py-3 font-medium cursor-pointer text-white rounded-xl ${isEdited ? " bg-[#0046AE]" : "bggradient"
                      }`}
                  >
                    Next
                  </button>
                </div>
              </div>
            </div>
          </div>
          {/* Divider */}
          <div className="flex justify-center py-2">
            <div className="bg-[#CCCCCC] h-[1.5px] w-[950px]"></div>
          </div>

          {/* Logo */}
          <div className="sm:flex justify-between w-full max-w-[970px] mx-auto px-4 pb-4 sm:pb-0">
            <div className="flex items-center gap-2">
              <img src={Logo} alt="Logo" className="w-[8rem] h-[2.7rem]" />
            </div>

            <p className="font-poppins text-[#535353] text-sm">
              @2025 | All rights reserved by{" "}
              <a
                className="text-[#2A2A2A] underline font-semibold cursor-pointer"
                href="https://primocys.com/"
                target="_blank"
              >
                Primocys
              </a>
              .
            </p>
          </div>
        </div>
      </div>
    </>
  );
}

export default Page3;
