import Background from "../../assets/Images/installbgimage.png";
import Logo from "../../assets/Images/logo.png";
import LightVector from "../../assets/Images/LightVector.png";
import InfoCircle from "../../assets/Images/info.png";
import LightStroke from "../../assets/Images/LightStroke.png";
import { useAuth } from "../../utils/AuthContext";
import { useNavigate } from "react-router-dom";
import Tick from "../../assets/Images/DoneTick.png"


function Page4() {
  const { verifyToken } = useAuth();
  const navigate = useNavigate();

  const handleContinue = async () => {
    await verifyToken();
    navigate("/signin");
    sessionStorage.removeItem("show_varification_steps");
    window.location.reload()
  };
  return (
    <>
      <div className="relative w-full h-screen">
        {/* Background Image */}
        <img
          src={Background}
          alt="Background"
          className="object-cover w-full h-full"
        />

        {/* Overlay Content */}
        <div className="absolute inset-0 flex flex-col">
          {/* Top Right Logo and Snapta */}
          <div className="flex justify-center p-8  sm:justify-end xl:mr-[4rem]">
            <div className="flex items-center gap-3">
              <img src={Logo} alt="Logo" className=" w-[10rem]" />
            </div>
          </div>

          {/* Center Title */}
          <div className="justify-center">
            <h2 className="text-[#000000] sm:text-4xl text-xl font-semibold font-poppins text-center">Nlytical App Software Installation</h2>
            <p className="text-[#000000] font-poppins sm:text-base text-center pt-2">Please make sure the PHP extensions listed below are installed</p>
          </div>

          {/* No. of Steps */}
          <div className="flex justify-center py-3 sm:gap-3 place-items-center">
            <button
              className={`rounded-full px-5 py-2 bggradient text-[#FFFFFF] font-poppins`}
            >
              1
            </button>
            <img src={LightVector} className="w-16" />
            <button
              className={`rounded-full px-4 py-2 bggradient text-[#FFFFFF] font-poppins`}
            >
              2
            </button>
            <img src={LightVector} className="w-16" />
            <button
              className={`rounded-full px-4 py-2 bggradient text-[#FFFFFF] font-poppins`}
            >
              3
            </button>
            <img src={LightStroke} className="w-16" />
            <button
              className={`rounded-full px-4 py-2 bggradient text-[#FFFFFF] font-poppins`}
            >
              4
            </button>

          </div>

          {/* Centered Div */}
          <div className="flex justify-center w-full py-6">



            <div className="flex justify-center py-6 sm:w-full w-fit ">
              <div
                className="bg-[#FFFFFF]  sm:w-[950px] rounded-md p-6"
                style={{ boxShadow: "8px 9px 55.9px 0px #00000033" }}
              >
                <div className="justify-between sm:flex">
                  <h2 className="font-poppins text-[#000000] text-base flex flex-row">
                    Step 4 :
                    <div className="flex flex-col">
                      <span className="font-poppins text-[#555555] text-base pl-1">
                        Installation Complete
                      </span>
                      <span className="text-[#000000] text-sm sm:block hidden font-poppins pl-1">
                        Your setup is successfull now you can go to Admin or Website login
                      </span>
                    </div>
                  </h2>
                  <span className="text-[#000000] text-sm  font-poppins sm:hidden block">
                    Your setup is successfull now you can go to Admin or Website login
                  </span>
                  <div className="flex gap-1 place-items-center">
                    <a
                      target="_blank"
                      href="https://document.snapta.online/"
                      className="font-poppins text-[#435CFF] underline text-xs cursor-pointer"
                    >
                      Read documentation
                    </a>

                    <img src={InfoCircle} className="w-3 h-3" />
                  </div>
                </div>
                {/* Inner Div */}
                <div className="flex justify-center py-4 xl:py-3 sm:px-4">
                  <div
                    className="sm:w-[800px] place-items-center rounded-lg py-12 px-10"
                  >
                    <h2 className="text-[#000000] font-poppins font-semibold text-center">
                      All Done!
                    </h2>
                    <img src={Tick} className="w-20 py-4" />
                    <div className="flex gap-3">
                      <button
                        onClick={handleContinue}
                        className="font-poppins text-[#FFFFFF]  cursor-pointer py-2 bggradient rounded-lg px-6 mt-8"
                      >
                        Continue to Admin
                      </button>
                      <button
                        // onClick={}
                        className="font-poppins hidden text-[#FFFFFF] py-2  cursor-pointer bggradient rounded-lg px-6 mt-8"
                      >
                        Continue to Website
                      </button>
                    </div>
                  </div>
                </div>
              </div>




            </div>
          </div>
          {/* Divider */}
          <div className="flex justify-center py-2">
            <div className="bg-[#CCCCCC] h-[2px] w-[950px]"></div>
          </div>

          {/* Logo */}
          <div className="sm:flex justify-between w-full max-w-[970px] mx-auto px-4 pb-4 sm:pb-0">
            <div className="flex items-center gap-2">
              <img src={Logo} alt="Logo" className="w-[8rem] h-[2.7rem]" />
            </div>

            <p className="font-poppins text-[#535353] text-sm">
              @2025 | All rights reserved by{" "}
              <a
                className="text-[#2A2A2A] underline font-semibold cursor-pointer"
                href="https://primocys.com/"
                target="_blank"
              >
                Primocys
              </a>
              .
            </p>
          </div>
        </div>
      </div>
    </>
  )
}

export default Page4
