import { useSelector } from "react-redux";
import SearchBar from "../../Componets/SearchBar/SearchBar";
import { Link, useLocation, useNavigate } from "react-router-dom";
import WithoutSorttableHeader from "../../Componets/TableComponets/WithoutSorttableHeader";
import Search from "../../assets/Images/search.png";
import Add from "../../assets/Images/add.png";
import { useAppDispatch, useAppSelector } from "../../Hooks/Hooks";
import useApiPost from "../../Hooks/PostData";
import { useEffect, useState } from "react";
import { setPaginationUserReportlList } from "../../Appstore/Slice/PaginationSlice/UserReportListPaginationSlice";
import notfound from "../../assets/Images/notfound.png";
import AvatarWithSpinner from "../../Componets/LoadingComponest";
import UserReportListPagination from "../../Componets/PaginationComponets/UserReportListPagination";
import { IoStar } from "react-icons/io5";
import TableUserInfo from "../../Componets/TableComponets/TableUserInfo";
import SimpletextTableBody from "../../Componets/TableComponets/SimpletextTableBody";
import EditIcon from "../../assets/Images/edit.png";
import TableActionButtons from "../../Componets/TableComponets/TableActionButtons";
import Eye from "../../assets/Images/eye.png";
import Block from "../../assets/Images/deleteicon.png";
import TableDateTimeDisplay from "../../Componets/TableComponets/TableDateTimeDisplay";
import SubscribedVendorPagination from "../../Componets/PaginationComponets/SubscribedVendorPagination";
import SponsorListPagination from "../../Componets/PaginationComponets/SponsorListPagination";
import { setPaginationSponsorList } from "../../Appstore/Slice/PaginationSlice/SponsorListPaginationSlice";
import SimpletextTableBodyReview from "../../Componets/TableComponets/SimpletextTableBodyReview";

function SponsorList() {
    const isSidebarOpen = useSelector((state: any) => state.sidebar.isOpen);
    const { data, loading, error, postData } = useApiPost();
    const pagination = useAppSelector((state) => state.SponsorListPaginationSlice);
    const { current_page, records_per_page } = pagination;
    const [search, setSearch] = useState("");

    const dispatch = useAppDispatch();

    // Fetch data
    useEffect(() => {
        const params = {
            page: current_page,
            pageSize: records_per_page,
            search: search.trim(),
        };

        postData("/sponser-payment", params);
    }, [current_page, records_per_page, search]);

    useEffect(() => {
        if (data?.Pagination) {
            dispatch(setPaginationSponsorList(data?.Pagination));
        }
    }, [data, dispatch]);


    const navigate = useNavigate();
    const location = useLocation();

    const handleView = (vendor: string) => {
        const currentPath = location.pathname.split('/')[1];
        navigate(`/${currentPath}/sponsor-list-view`);
        sessionStorage.setItem("goal_payment_id", vendor?.goal_payment_id || "")


    };



    const defaultCurrency = sessionStorage.getItem("defaultCurrency")

    return (
        <div className={`bg-primary ${isSidebarOpen ? "xl:pl-20" : "xl:pl-72"}`}>
            <SearchBar />
            <div className="px-4 pb-10 xl:px-6">
                <div className="flex justify-between border-t-[#F2F2F2] py-3">
                    <h2 className="text-textcolor font-poppins text-xl font-semibold pt-3">Sponsor List </h2>
                    <div className="relative">
                        <div className="absolute left-2 top-1/2 flex transform -translate-y-1/2 items-center p-2">
                            <img src={Search} alt="Search" className="h-4 w-4 md:h-5 md:w-5" />
                        </div>
                        <div className=" w-full">
                            <input
                                type="text"
                                placeholder="Search by sponsor-name and store-name..."
                                className="w-[180px] md:w-[350px] pl-10 py-2 text-sm placeholder:text-placeholdercolor
              border border-bordercolor border-opacity-10 rounded-lg bg-[#00000005] 
              focus:outline-none focus:ring-1 focus:ring-gray-600 
              placeholder:dark:text-tableDarkLarge "
                                onChange={(e) => setSearch(e.target.value)}
                                value={search}
                            />
                        </div>
                    </div>
                </div>

                <div className="flex items-center justify-between">
                    <div className="flex items-center gap-2">
                        <Link to="/dashboard">
                            <h3 className="text-[#3A3A3A] font-poppins text-base font-semibold">Dashboard</h3>
                        </Link>
                        <div className="rounded-full w-1 h-1 bg-[#E0E0E0]" />
                        <h3 className="text-[#858585] font-poppins text-base">Sponsor List</h3>
                    </div>


                </div>

                <div className="relative border border-bordercolor rounded-lg mt-8 mx-4 sm:mx-0 overflow-x-auto w-full">
                    <div className="min-w-[1200px]">
                        {/* Table Header */}
                        <div className="flex items-center px-4 py-4 text-left border-b bg-headercolortable border-b-bordercolor sm:pl-8 gap-4 font-medium text-sm text-textcolor">
                            <div className="w-[4%]"><WithoutSorttableHeader label="S.L" /></div>
                            <div className="w-[10%]"><WithoutSorttableHeader label="SPONSOR NAME" /></div>
                            <div className="w-[10%]"><WithoutSorttableHeader label="STORE" /></div>
                            <div className="w-[5%]"><WithoutSorttableHeader label="DAYS" /></div>
                            <div className="w-[10%]"><WithoutSorttableHeader label="PRICE" /></div>
                            <div className="w-[10%]"><WithoutSorttableHeader label="START DATE" /></div>
                            <div className="w-[10%]"><WithoutSorttableHeader label="END DATE" /></div>
                            <div className="w-[10%]"><WithoutSorttableHeader label="PAYMENT MODE" /></div>
                            <div className="w-[16%]"><WithoutSorttableHeader label="CREATED DATE/TIME" /></div>
                            <div className="w-[10%]"><WithoutSorttableHeader label="STATUS" /></div>
                            <div className="w-[5%]"><WithoutSorttableHeader label="ACTION" /></div>

                        </div>

                        {/* Table Body */}
                        <div className="relative">
                            {loading ? (
                                <div className="h-[400px] flex items-center justify-center">
                                    <AvatarWithSpinner />
                                </div>
                            ) : data?.GoalData?.length > 0 ? (
                                data.GoalData.map((gift: any, index: number) => (
                                    <div
                                        key={gift.gift_id}
                                        className={`flex items-center px-4 py-3 border-b border-bordercolor sm:pl-8 text-sm font-poppins gap-4 ${index % 2 === 0 ? "bg-white dark:bg-primary" : "bg-[#00162e0a] dark:bg-primary"
                                            }`}
                                    >
                                        <div className="w-[4%]">{(current_page - 1) * records_per_page + index + 1}</div>
                                        <div className="w-[10%] whitespace-pre-wrap break-words text-textcolor"><SimpletextTableBodyReview title={gift.campaign_name} /></div>
                                        <div className="w-[10%] whitespace-pre-wrap break-words text-textcolor"><SimpletextTableBodyReview title={gift.service_name} /></div>
                                        <div className="w-[5%]"><SimpletextTableBody title={gift.days} /></div>
                                        <div className="w-[10%]"><SimpletextTableBody title={` ${defaultCurrency}${gift.goal_price}`} /></div>
                                        <div className="w-[10%]"><SimpletextTableBody title={gift.start_date} /></div>
                                        <div className="w-[10%]"><SimpletextTableBody title={gift.end_date} /></div>

                                        {/* Payment Mode */}
                                        <div className="w-[10%]">
                                            <div
                                                className={`w-fit rounded-xl px-3 py-1 font-medium ${gift?.payment_mode === "user"
                                                    ? "bg-[#D4F1E0] text-[#4CAF50]"
                                                    : gift?.payment_mode === "vendor"
                                                        ? "bg-[#D2DFF5] text-[#0046AE]"
                                                        : gift?.payment_mode === "stripe"
                                                            ? "bg-[#E0F7FA] text-[#00ACC1]"
                                                            : gift?.payment_mode === "flutterwave"
                                                                ? "bg-[#FFF3E0] text-[#FB8C00]"
                                                                : gift?.payment_mode === "razorpay"
                                                                    ? "bg-[#F3E5F5] text-[#8E24AA]"
                                                                    : gift?.payment_mode === "paypal"
                                                                        ? "bg-[#E0E7FF] text-[#003087]" // Blue tones for PayPal
                                                                        : gift?.payment_mode === "applepay"
                                                                            ? "bg-[#F0F0F0] text-[#000000]" // Clean white/black for Apple
                                                                            : gift?.payment_mode === "googlepay"
                                                                                ? "bg-[#FBE9E7] text-[#DB4437]" // Google red
                                                                                : "bg-gray-200 text-gray-600"
                                                    }`}
                                            >
                                                {{
                                                    user: "Customer",
                                                    vendor: "Vendor",
                                                    stripe: "Stripe",
                                                    flutterwave: "Flutterwave",
                                                    razorpay: "Razorpay",
                                                    paypal: "PayPal",
                                                    applepay: "Apple Pay",
                                                    googlepay: "Google Pay",
                                                }[gift?.payment_mode] || "Unknown"}
                                            </div>
                                        </div>


                                        <div className="w-[16%]"><TableDateTimeDisplay dateString={gift.created_at} /></div>
                                        <div className=" w-[10%]">
                                            <div
                                                className={`w-fit rounded-xl px-3 py-1 font-normal ${gift?.all_status === "1"
                                                    ? "bg-green-100 text-green-600"
                                                    : "bg-red-100 text-red-600"
                                                    }`}
                                            >
                                                {gift?.all_status === "1" ? "Active" : "Expired"}
                                            </div>
                                        </div>
                                        {/* Action */}
                                        <div className="w-[5%]">
                                            <TableActionButtons
                                                viewButtonIcon={Eye}
                                                onViewClick={() => handleView(gift)}
                                                viewButtonColor="#CCE1CD"
                                                borderColor="#01D312"
                                            />
                                        </div>
                                    </div>
                                ))
                            ) : (
                                <div className="p-4 h-[38rem] flex justify-center items-center">
                                    <div className="w-full flex flex-col items-center h-full justify-center">
                                        <img src={notfound} alt="Not Found" className="w-1/2 max-h-[40vh] object-contain" />
                                        <h2 className="font-poppins text-lg text-textcolor mt-4">No  Data Found</h2>
                                    </div>
                                </div>
                            )}
                        </div>
                    </div>

                    {/* Pagination */}
                    <SponsorListPagination />
                </div>


            </div>
        </div>
    );
}
export default SponsorList;
