import { useSelector } from "react-redux";
import SearchBar from "../../Componets/SearchBar/SearchBar";
import { Link, useNavigate } from "react-router-dom";
import WithoutSorttableHeader from "../../Componets/TableComponets/WithoutSorttableHeader";
import Search from "../../assets/Images/search.png";
import Add from "../../assets/Images/add.png";
import { useAppDispatch, useAppSelector } from "../../Hooks/Hooks";
import useApiPost from "../../Hooks/PostData";
import { useEffect, useState } from "react";
import { setPaginationUserReportlList } from "../../Appstore/Slice/PaginationSlice/UserReportListPaginationSlice";
import notfound from "../../assets/Images/notfound.png";
import AvatarWithSpinner from "../../Componets/LoadingComponest";
import UserReportListPagination from "../../Componets/PaginationComponets/UserReportListPagination";
import { IoStar } from "react-icons/io5";
import TableUserInfo from "../../Componets/TableComponets/TableUserInfo";
import SimpletextTableBody from "../../Componets/TableComponets/SimpletextTableBody";
import EditIcon from "../../assets/Images/edit.png";
import TableActionButtons from "../../Componets/TableComponets/TableActionButtons";
import Eye from "../../assets/Images/eye.png";
import Block from "../../assets/Images/deleteicon.png";
import TableDateTimeDisplay from "../../Componets/TableComponets/TableDateTimeDisplay";
import { clearAddPostData } from "../../Appstore/Slice/Storevalues/AddStoreSlice";
import { clearVendordetail } from "../../Appstore/Slice/VendorSlice";
import { clearSelectedCategory } from "../../Appstore/Slice/CategorySelectedIDandValues";
import { resetSubCategoryState } from "../../Appstore/Slice/SubCategorySlice";
import { clearall } from "../../Appstore/Slice/Storevalues/StoreaddDescription";
import { resetDays } from "../../Appstore/Slice/Storevalues/OpenDaySlice";
import { clearCoverImageatc } from "../../Appstore/Slice/UploadServiceAttactmentSlice";
import { clearAllCoverImages } from "../../Appstore/Slice/UploadAddserviceImageSlice";
import { clearall12 } from "../../Appstore/Slice/AddSubcriptionDescription";
import { showModal } from "../../Appstore/Slice/ModalSlice";
import { reset } from "../../Appstore/Slice/toggleSlice";
import toast from "react-hot-toast";

function StoreList() {
    const isSidebarOpen = useSelector((state: any) => state.sidebar.isOpen);
    const { data, loading, error, postData } = useApiPost();
    const pagination = useAppSelector((state) => state.UserReportListPaginationSlice);
    const { current_page, records_per_page } = pagination;
    const [search, setSearch] = useState("");





    const dispatch = useAppDispatch();

    // Fetch data
    useEffect(() => {
        const params = {
            page: current_page,
            pageSize: records_per_page,
            search: search.trim(),
        };

        postData("/service-listadmin", params);
    }, [current_page, records_per_page, search]);

    useEffect(() => {
        if (data?.Pagination) {
            dispatch(setPaginationUserReportlList(data?.Pagination));
        }
    }, [data, dispatch]);




    const isapical = useAppSelector((state) => state.toggle.value)


    useEffect(() => {
        if (isapical) {
            const payload = new FormData()
            postData("/service-listadmin", payload);
        }
    }, [isapical])


    const navigate = useNavigate();


    const handleNaviagte = () => {

       
        navigate(`/add-store`);
        dispatch(clearAddPostData())

        dispatch(clearSelectedCategory())
        dispatch(resetSubCategoryState())
        dispatch(clearall())
        dispatch(resetDays())
        dispatch(clearCoverImageatc())
        dispatch(clearAllCoverImages())
        dispatch(clearall12())
    };




    const handalupdatestore = (id: string) => {
      
        sessionStorage.setItem("storID", id)
        const currentPath = location.pathname.split("/")[1];
        dispatch(clearVendordetail())
        navigate(`/${currentPath}/update-store`);
    }



    const handalview = (id: string) => {
        sessionStorage.setItem("storIDViews", id)
        const currentPath = location.pathname.split("/")[1];
        navigate(`/${currentPath}/view-store`);
    }


    const handaldelete = (id: string) => {
        
        sessionStorage.setItem("deletestoreid", id)
        dispatch(showModal("StooreDeleteModal"))
        dispatch(reset())
    }



    const handalvendorview = (id: string) => {

        sessionStorage.setItem("user_id", id)
        navigate(`/View-Vendor`);
    };


    return (
        <div className={`bg-primary ${isSidebarOpen ? "xl:pl-20" : "xl:pl-72"}`}>
            <SearchBar />
            <div className="px-4 pb-10 xl:px-6">
                <div className="flex justify-between border-t-[#F2F2F2] py-3">
                    <h2 className="text-textcolor font-poppins text-xl font-semibold pt-3">Store List</h2>
                    <div className="relative">
                        <div className="absolute left-2 top-1/2 flex transform -translate-y-1/2 items-center p-2">
                            <img src={Search} alt="Search" className="h-4 w-4 md:h-5 md:w-5" />
                        </div>
                        <div className=" w-full">
                            <input
                                type="text"
                                placeholder="Search by store-name..."
                                className="w-[180px] md:w-[250px] pl-10 py-2 text-sm placeholder:text-placeholdercolor
              border border-bordercolor border-opacity-10 rounded-lg bg-[#00000005] 
              focus:outline-none focus:ring-1 focus:ring-gray-600 
              placeholder:dark:text-tableDarkLarge "
                                onChange={(e) => setSearch(e.target.value)}
                                value={search}
                            />
                        </div>
                    </div>
                </div>

                <div className="flex items-center justify-between">
                    <div className="flex items-center gap-2">
                        <Link to="/dashboard">
                            <h3 className="text-[#3A3A3A] font-poppins text-base font-semibold">Dashboard</h3>
                        </Link>
                        <div className="rounded-full w-1 h-1 bg-[#E0E0E0]" />
                        <h3 className="text-[#858585] font-poppins text-base">Store List</h3>
                    </div>

                    <button className="flex gap-1.5 mr-1 py-2 cursor-pointer place-items-center px-4 font-poppins font-medium text-white rounded-md bggradient" onClick={handleNaviagte}  >
                        <img src={Add} className="w-4 h-4" />
                        <p className="md:text-sm text-xs">Add Store</p>
                    </button>
                </div>

                <div className="relative border border-bordercolor rounded-lg mt-8 mx-4 sm:mx-0 overflow-x-auto w-full">
                    <div className="min-w-[1200px]">
                        {/* Table Header */}
                        <div className="flex items-center px-4 py-4 text-left border-b bg-headercolortable border-b-bordercolor sm:pl-8 gap-4">
                            <div className="w-[4%]">
                                <WithoutSorttableHeader label="S.L" />
                            </div>
                            <div className="w-[25%]">
                                <WithoutSorttableHeader label="STORE" />
                            </div>
                            <div className="w-[19%]">
                                <WithoutSorttableHeader label="VENDOR" />
                            </div>

                            <div className=" w-[9%]">
                                <WithoutSorttableHeader label="SERVICE COUNT" />
                            </div>
                            <div className="w-[10%]">
                                <WithoutSorttableHeader label="CATEGORY" />
                            </div>
                            <div className="w-[10%]">
                                <WithoutSorttableHeader label="CITY" />
                            </div>
                            {/* <div className="w-[7%]">
                                <WithoutSorttableHeader label="PRICE" />
                            </div> */}
                            <div className="w-[10%]">
                                <WithoutSorttableHeader label="CREATED DATE/TIME" />
                            </div>
                            <div className="w-[13%]">
                                <WithoutSorttableHeader label="ACTION" />
                            </div>
                        </div>

                        <div className="relative">
                            {loading ? (
                                <div className="h-[400px] flex items-center justify-center">
                                    <AvatarWithSpinner />
                                </div>
                            ) : data?.ServiceList?.length > 0 ? (
                                data.ServiceList.map((gift: any, index: number) => (
                                    <div key={gift.gift_id} className={`flex items-center px-4 py-3 border-b border-bordercolor sm:pl-8 ${index % 2 === 0 ? "bg-white dark:bg-primary" : "bg-[#00162e0a] dark:bg-primary"}`}>
                                        {/* S.L */}
                                        <div className="w-[4%] text-sm text-textcolor font-poppins">{(current_page - 1) * records_per_page + index + 1}</div>

                                        {/* Store */}
                                        <div className="w-[25%] flex gap-3 items-center cursor-pointer" onClick={() => handalview(gift.id)} >
                                            <div className="w-10 h-10 rounded-full overflow-hidden">
                                                <img src={gift.service_images[0]} alt="Service" className="w-full h-full object-cover" />
                                            </div>
                                            <div className="flex flex-col">
                                                <div className="flex items-center gap-2">
                                                    <h4 className="text-[#0046AE] text-sm font-poppins">{gift.service_name}</h4>
                                                    <div className="flex items-center gap-1">
                                                        <IoStar className="text-yellow-400" />
                                                        <p className="text-gray-400 text-sm font-poppins">{gift.avg_review}</p>
                                                    </div>
                                                </div>
                                                <p className="text-[#a4a9b4] font-poppins">Price: {gift.price_range}</p>
                                            </div>
                                        </div>

                                        {/* Vendor */}
                                        <div className="w-[19%]">
                                            <TableUserInfo
                                                profilePic={gift.image}
                                                username={gift.vendor_name}
                                                email={gift.email || "N/A"}
                                                mobile={gift.country_code ? `${gift.country_code} ${gift.mobile || ""}` : "N/A"}
                                                onClick={() => { handalvendorview(gift.vendor_id) }}
                                            />
                                        </div>

                                        {/*  service count  */}

                                        <div className=" w-[9%] relative  right-[-1.8rem]">
                                            <SimpletextTableBody title={gift.service_count} />
                                        </div>

                                        {/* Category */}
                                        <div className="w-[10%]">
                                            <SimpletextTableBody title={gift.category_name} />
                                        </div>

                                        {/* City */}
                                        <div className="w-[10%]">
                                            <SimpletextTableBody title={gift.city} />
                                        </div>

                                        {/* Price */}
                                        {/* <div className="w-[7%]">
                                            <SimpletextTableBody title={gift.price_range} />
                                        </div> */}

                                        {/* Date/Time */}
                                        <div className="w-[10%]">
                                            <TableDateTimeDisplay dateString={gift.created_at} />
                                        </div>

                                        {/* Actions */}
                                        <div className="w-[13%] flex items-center gap-3 justify-center">
                                            <button className="py-[9px] px-[10px] bg-[#D0CCE1]/60 cursor-pointer rounded-full" onClick={() => {
                                                handalupdatestore(gift.id)
                                            }} >
                                                <img src={EditIcon} alt="Edit" className="w-5 h-4" />
                                            </button>
                                            <TableActionButtons viewButtonIcon={Eye} onViewClick={() => handalview(gift.id)} onBlockClick={() => handaldelete(gift.id)} viewButtonColor="#CCE1CD" blockButtonColor="#FDE4EA" borderColor="#01D312" blockButtonIcon={Block} />
                                        </div>
                                    </div>
                                ))
                            ) : (
                                <div className="p-4 h-[38rem] flex justify-center items-center">
                                    <div className="w-full flex flex-col items-center h-full justify-center">
                                        <img src={notfound} alt="Not Found" className="w-1/2 max-h-[40vh] object-contain" />
                                        <h2 className="font-poppins text-lg text-textcolor mt-4">No  Data Found</h2>
                                    </div>
                                </div>
                            )}
                        </div>
                    </div>
                    <UserReportListPagination />
                </div>
            </div>
        </div>
    );
}
export default StoreList;
