import React, { useEffect, useState } from "react";
import WithoutSorttableHeader from "../../../../Componets/TableComponets/WithoutSorttableHeader";
import AvatarWithSpinner from "../../../../Componets/LoadingComponest";
import { useAppDispatch, useAppSelector } from "../../../../Hooks/Hooks";
import { setPaginationReelList } from "../../../../Appstore/Slice/PaginationSlice/ReelListPaginationSlice";
import useApiPost from "../../../../Hooks/PostData";
import notfound from "../../../../assets/Images/notfound.png";
import ReelListPagination from "../../../../Componets/PaginationComponets/ReelListPagination";
import TableUserInfo from "../../../../Componets/TableComponets/TableUserInfo";
import { IoStar } from "react-icons/io5";
import SimpletextTableBody from "../../../../Componets/TableComponets/SimpletextTableBody";

function ServiceListStoreView() {
    const dispatch = useAppDispatch();

    const pagination = useAppSelector((state) => state.ReelListPaginationSlice);
    const { current_page, records_per_page } = pagination;
    const isApiCallTriggered = useAppSelector((state) => state.toggle.value);

    const [search, setSearch] = useState("");

    const { data, postData, loading } = useApiPost();


 const defaultCurrency = sessionStorage.getItem("defaultCurrency")

    console.log("datadatadatav", data?.service?.stores)



    const storIDViews = sessionStorage.getItem("storIDViews");

    /**
     * Fetch reel list data based on pagination and search
     */
    useEffect(() => {
        if (!storIDViews) return;

        const params = {
            page: current_page,
            pageSize: records_per_page,
            search: search.trim(),
            service_id: storIDViews,
        };

        postData("/view-service", params);
    }, [current_page, records_per_page, search, storIDViews]);

    /**
     * Update pagination state from API response
     */
    useEffect(() => {
        if (data?.Pagination) {
            dispatch(setPaginationReelList(data.Pagination));
        }
    }, [data?.Pagination, dispatch]);

    /**
     * Trigger API call manually when toggle is set
     */
    useEffect(() => {
        if (isApiCallTriggered) {
            const payload = new FormData();
            if (storIDViews) payload.append("service_id", storIDViews);

            postData("/view-service", payload);
        }
    }, [isApiCallTriggered]);

    return (
        <>
            <div className=" p-4">
                <div className="relative border border-bordercolor   rounded-lg mt-8 mx-4 sm:mx-0 overflow-x-auto w-full">
                    <div className="min-w-[1200px]">
                        {/* Table Header */}
                        <div className="flex items-center px-4 py-4 text-left border-b bg-headercolortable border-b-bordercolor sm:pl-8 gap-4">
                            <div className="w-[10%]">
                                <WithoutSorttableHeader label="S.L" />
                            </div>
                            <div className="w-[40%]">
                                <WithoutSorttableHeader label="SERVICE" />
                            </div>
                            <div className="w-[40%]">
                                <WithoutSorttableHeader label="VENDOR" />
                            </div>

                            <div className="w-[10%]">
                                <WithoutSorttableHeader label="PRICE" />
                            </div>
                        </div>
                        {data?.service?.stores?.length > 0 ? (
                            data.service.stores.map((store, index) => (
                                <div
                                    key={store.id}
                                    className="flex items-center px-4 py-3 border-b border-bordercolor sm:pl-8 bg-white dark:bg-primary"
                                >
                                    {/* S.L */}
                                    <div className="w-[10%] text-sm text-textcolor font-poppins">
                                        {index + 1}
                                    </div>

                                    {/* Store */}
                                    <div className="w-[40%] flex gap-3 items-center">
                                        <div className="w-10 h-10 rounded-full overflow-hidden">
                                            <img
                                                src={store.store_images?.[0]?.url}
                                                alt="Store"
                                                className="w-full h-full object-cover"
                                            />
                                        </div>
                                        <div className="flex flex-col">
                                            <div className="flex items-center gap-2">
                                                <h4 className="text-[#0046AE] text-sm font-poppins">
                                                    {store.store_name}
                                                </h4>
                                                <div className="flex items-center gap-1 hidden">
                                                    <IoStar className="text-yellow-400" />
                                                    <p className="text-gray-400 text-sm font-poppins">
                                                        {data.service.avg_review || "N/A"}
                                                    </p>
                                                </div>
                                            </div>
                                            <p className="text-[#a4a9b4] font-poppins">
                                                Price: {data.service.price_range || store.price || "N/A"}
                                            </p>
                                        </div>
                                    </div>

                                    {/* Vendor */}
                                    <div className="w-[40%]     ">
                                        <TableUserInfo
                                            profilePic={data.service.vendor?.image}
                                            username={`${data.service.vendor?.first_name || ""} ${data.service.vendor?.last_name || ""}`}
                                            email={data.service.vendor?.email || "N/A"}
                                            mobile="N/A"
                                            onClick={() => { }}
                                        />
                                    </div>

                                    {/* Price Column */}
                                    <div className="w-[10%]">
                                        <SimpletextTableBody title={`${store.price}${defaultCurrency} `} />
                                    </div>
                                </div>
                            ))
                        ) : (
                            <div className="p-4 h-[38rem] flex justify-center items-center">
                                <div className="w-full flex flex-col items-center h-full justify-center">
                                    <img
                                        src={notfound}
                                        alt="Not Found"
                                        className="w-1/2 max-h-[40vh] object-contain"
                                    />
                                    <h2 className="font-poppins text-lg text-textcolor mt-4">
                                        No Data Found
                                    </h2>
                                </div>
                            </div>
                        )}

                    </div>
                    {/* <ReelListPagination /> */}
                </div>
            </div>
        </>
    );
}

export default ServiceListStoreView;
