"use client";

import React, { useEffect, useRef, useState } from "react";
import { useAppSelector } from "../../../../Hooks/Hooks";

function HeaderSectionImage() {
  const sliceImage = useAppSelector((state) => state.adminStore.data);
  const images = sliceImage?.service?.stores?.service_images || [];

  const [selectedImage, setSelectedImage] = useState<string | null>(null);
  const imageRefs = useRef<Array<HTMLImageElement | null>>([]);

  // Set default image
  useEffect(() => {
    if (images.length > 0) {
      setSelectedImage(images[0]?.url ?? null);
    }
  }, [images]);

  const handleThumbnailClick = (imgUrl: string, index: number) => {
    setSelectedImage(imgUrl);

    const targetIndex =
      index === 0
        ? images.length - 1
        : index === images.length - 1
        ? 0
        : index;

    const refToScroll = imageRefs.current[targetIndex];
    if (refToScroll) {
      refToScroll.scrollIntoView({
        behavior: "smooth",
        block: "nearest",
      });
    }
  };

  return (
    <div className="flex  flex-col  md:flex-row gap-4  rounded-xl">
      {/* Left thumbnails */}
      <div className="flex  flex-row md:flex-col gap-2 max-h-[400px] overflow-y-auto hide-scrollbar">
        {images.map((img, index) => (
          <img
            key={img.id}
            ref={(el) => (imageRefs.current[index] = el)}
            src={img.url}
            alt={`Thumbnail ${index + 1}`}
            onClick={() => handleThumbnailClick(img.url, index)}
            className={`w-[120px] h-[100px] rounded-lg object-cover cursor-pointer transition-all duration-200 ${
              selectedImage === img.url ? "ring-2 ring-blue-500" : ""
            }`}
          />
        ))}
      </div>

      {/* Right: Main image display as background */}
      <div className="flex-1 flex items-center justify-center">
        {selectedImage ? (
          <div
            className="w-full h-[400px] rounded-xl bg-no-repeat   bg-center bg-contain bg-gray-100"
            style={{
              backgroundImage: `url(${selectedImage})`,
            }}
          />
        ) : (
          <div className="w-full h-[300px] bg-gray-200 rounded-xl flex items-center justify-center">
            No image available
          </div>
        )}
      </div>
    </div>
  );
}

export default HeaderSectionImage;
