"use client";

import React from "react";
import fbicon from "../../../../assets/Images/facebook.png";
import insta from "../../../../assets/Images/instafotter.png";
import twitter from "../../../../assets/Images/twitter.png";
import whatshop from "../../../../assets/Images/whatshop.png";
import { useAppSelector } from "../../../../Hooks/Hooks";

function SocilMediicon() {
    const follow_us = useAppSelector((state) => state.adminStore.data?.service?.follow_us);

    // Destructure and fallback to empty string
    const {
        facebook_link = "",
        instagram_link = "",
        twitter_link = "",
        whatsapp_link = "",
    } = follow_us || {};

    // Check if at least one social link exists
    const hasSocialMedia =
        facebook_link || instagram_link || twitter_link || whatsapp_link;

    if (!hasSocialMedia) return null;

    return (
        <div className="p-4 rounded-lg bg-primary  text-textcolor border border-bordercolor">
            <div className="text-lg font-medium font-poppins mb-4">Follow Us On</div>

            <div className="w-full flex gap-2 flex-wrap">
                {/* Facebook */}
                {facebook_link && (
                    <a href={facebook_link} target="_blank" rel="noreferrer">
                        <div className="flex items-center gap-2 p-2 cursor-pointer rounded-xl border border-bordercolor">
                            <img src={fbicon} alt="Facebook" className="w-6 h-6" />
                            <span className="font-medium">Facebook</span>
                        </div>
                    </a>
                )}

                {/* Instagram */}
                {instagram_link && (
                    <a href={instagram_link} target="_blank" rel="noreferrer">
                        <div className="flex items-center gap-2 p-2 cursor-pointer rounded-xl border border-bordercolor">
                            <img src={insta} alt="Instagram" className="w-6 h-6" />
                            <span className="font-medium">Instagram</span>
                        </div>
                    </a>
                )}

                {/* WhatsApp */}
                {whatsapp_link && (
                    <a
                        href={`https://wa.me/${whatsapp_link.replace(/\D/g, "")}`}
                        target="_blank"
                        rel="noreferrer"
                    >
                        <div className="flex items-center gap-2 p-2 cursor-pointer rounded-xl border border-bordercolor">
                            <img src={whatshop} alt="WhatsApp" className="w-6 h-6" />
                            <span className="font-medium">WhatsApp</span>
                        </div>
                    </a>
                )}

                {/* Twitter */}
                {twitter_link && (
                    <a href={twitter_link} target="_blank" rel="noreferrer">
                        <div className="flex items-center gap-2 p-2 cursor-pointer rounded-xl border border-bordercolor">
                            <img src={twitter} alt="Twitter" className="w-6 h-6" />
                            <span className="font-medium">Twitter</span>
                        </div>
                    </a>
                )}
            </div>
        </div>
    );
}

export default SocilMediicon;
