import { useState } from "react";
import { useAppSelector } from "../../../../Hooks/Hooks";

function StoreDescription() {
    const [isExpanded, setIsExpanded] = useState(false);

    // Get raw description from Redux state
    const rawDescription = useAppSelector(
        (state) => state.adminStore.data?.service?.stores?.service_description
    );

    // Clean inline background color styles
    const cleanedDescription = (rawDescription || "")
        .replace(/background-color\s*:\s*[^;"]+;?/gi, "")
        .replace(/color\s*:\s*rgb\(0,\s*0,\s*0\);?/gi, "") // Optional: Remove hardcoded black text
        .trim();

    return (
        <div className="p-4 rounded-lg border border-bordercolor dark:border-darkbordercolor">
            <div className="text-lg font-medium font-poppins text-textcolor dark:text-white mb-4">
                Store Description
            </div>

            <div
                className="text-sm font-poppins overflow-hidden text-textcolor dark:text-gray-300"
                style={{
                    maxHeight: isExpanded ? "none" : "4.5em",
                    display: "-webkit-box",
                    WebkitLineClamp: isExpanded ? "none" : 3,
                    WebkitBoxOrient: "vertical",
                }}
                dangerouslySetInnerHTML={{
                    __html: cleanedDescription || "No description available.",
                }}
            />

            {cleanedDescription && cleanedDescription.length > 100 && (
                <button
                    className="mt-2 text-[#0046AE] dark:text-blue-400 cursor-pointer font-semibold text-sm"
                    onClick={() => setIsExpanded(!isExpanded)}
                >
                    {isExpanded ? "See Less" : "See More"}
                </button>
            )}
        </div>
    );
}

export default StoreDescription;
