"use client";
import { useEffect, useRef } from "react";
import { useDispatch } from "react-redux";
import { CiSearch } from "react-icons/ci";
import { useGoogleMaps } from "../../../../Hooks/useGoogleMaps";
import locationicon from "../../../../assets/Images/location.png.png"
import { useAppSelector } from "../../../../Hooks/Hooks";

const StoreViewLocation = () => {
    const dispatch = useDispatch();
    const googleLoaded = useGoogleMaps();

        const sernamedetail = useAppSelector((state) => state.adminStore.data?.service)?.stores;
    

    const latvalues = parseFloat(sernamedetail?.lat || "");
    const lonvalues = parseFloat(sernamedetail?.lon || "");

    const mapRef = useRef<google.maps.Map | null>(null);
    const markersRef = useRef<google.maps.Marker[]>([]);

    useEffect(() => {
        if (googleLoaded && latvalues && lonvalues) {
            initAutocomplete(latvalues, lonvalues);
        }
    }, [googleLoaded, latvalues, lonvalues]);

    const initAutocomplete = (lat: number, lng: number) => {
        const input = document.getElementById("pac-input") as HTMLInputElement;
        const mapDiv = document.getElementById("map");

        if (!window.google || !input || !mapDiv) return;

        // Clean up any previous markers
        markersRef.current.forEach((marker) => marker.setMap(null));
        markersRef.current = [];

        // Initialize or update map
        if (!mapRef.current) {
            mapRef.current = new google.maps.Map(mapDiv, {
                center: { lat, lng },
                zoom: 13,
                mapTypeId: google.maps.MapTypeId.ROADMAP,
            });

            const searchBox = new google.maps.places.SearchBox(input);

            mapRef.current.addListener("bounds_changed", () => {
                searchBox.setBounds(mapRef.current!.getBounds() as google.maps.LatLngBounds);
            });

            searchBox.addListener("places_changed", () => {
                const places = searchBox.getPlaces();
                if (!places || places.length === 0) return;

                markersRef.current.forEach((marker) => marker.setMap(null));
                markersRef.current = [];

                const bounds = new google.maps.LatLngBounds();

                places.forEach((place) => {
                    if (!place.geometry || !place.geometry.location) return;

                    const marker = new google.maps.Marker({
                        map: mapRef.current!,
                        position: place.geometry.location,
                        title: place.formatted_address,
                    });

                    markersRef.current.push(marker);

                    if (place.geometry.viewport) {
                        bounds.union(place.geometry.viewport);
                    } else {
                        bounds.extend(place.geometry.location);
                    }


                   
                });

                mapRef.current!.fitBounds(bounds);
            });
        } else {
            mapRef.current.setCenter({ lat, lng });
        }
    };

    return (
        <div className=" border   rounded-lg  w-full  h-fit  border-bordercolor flex px-3  py-6  flex-col ">
            <h4 className=" font-poppins  text-lg text-[#3E5155]  ">Map</h4>
            <div className=" w-full flex gap-3  items-center py-4 ">
                <img src={locationicon} className="  h-4 w-[1rem]" />
                <span className=" font-poppins   text-textcolor  font-normal  text-sm ">{sernamedetail?.service_address}</span>
            </div>


            <div className="relative flex h-[25rem] md:h-[20rem] xl:h-full w-full flex-col rounded-xl">
                {/* Search input */}
                <div className="absolute top-4 left-1/2 z-50 w-[90%] max-w-md -translate-x-1/2">
                    <div className="relative w-full hidden">
                        <input
                            id="pac-input"
                            className="input-important w-full rounded-lg border p-4 pl-10 text-sm outline-none shadow-md"
                            type="text"
                            placeholder="Search for area, street name"
                        />
                        <CiSearch className="absolute left-3 top-1/2 -translate-y-1/2 transform text-xl text-gray-500" />
                    </div>
                </div>

                {/* Map */}
                <div
                    id="map"
                    className="flex-1 rounded-xl"
                    style={{ minHeight: "400px", height: "100%", width: "100%" }}
                />


            </div>
        </div>
    );
};

export default StoreViewLocation;
