import React, { useEffect, useState, useRef } from "react";
import playvideobtn from "../../../../assets/Images/play-button-arrowhead 1.png";
import ReactPlayer from "react-player";
import { useAppSelector } from "../../../../Hooks/Hooks";

function VideoSectionDetailScreen() {
  const video_url = useAppSelector(
    (state) => state?.adminStore?.data?.service?.stores?.video_url
  );


 
  console.log("video_urlvideo_url" ,video_url)


  const [videoUrl, setVideoUrl] = useState("");
  const [isPlaying, setIsPlaying] = useState(false);
  const playerRef = useRef<ReactPlayer | null>(null);

  // Validate and set video URL
  useEffect(() => {
    if (typeof video_url === "string" && video_url.trim()) {
      const trimmed = video_url.trim();
      if (trimmed !== videoUrl) {
        setVideoUrl(trimmed);
        setIsPlaying(false);
      }
    } else {
      setVideoUrl("");
      setIsPlaying(false);
    }
  }, [video_url]);

  // Utility functions
  const isYouTube = (url: string) => /youtube\.com|youtu\.be/.test(url);
  const isVimeo = (url: string) => /vimeo\.com/.test(url);
  const isVideoFile = (url: string) => /\.(mp4|mov|webm|ogg)$/i.test(url);

  const getYouTubeEmbedUrl = (url: string) => {
    try {
      const urlObj = new URL(url);
      const videoId = urlObj.hostname.includes("youtu.be")
        ? urlObj.pathname.slice(1)
        : urlObj.searchParams.get("v");
      return videoId
        ? `https://www.youtube.com/embed/${videoId}?autoplay=1&rel=0&origin=${window.location.origin}`
        : url;
    } catch {
      return url;
    }
  };

  const getVimeoEmbedUrl = (url: string) => {
    const match = url.match(/vimeo\.com\/(\d+)/);
    return match ? `https://player.vimeo.com/video/${match[1]}?autoplay=1` : url;
  };

  const getYouTubeThumbnail = (url: string) => {
    try {
      const urlObj = new URL(url);
      const videoId = urlObj.hostname.includes("youtu.be")
        ? urlObj.pathname.slice(1)
        : urlObj.searchParams.get("v");
      return videoId
        ? `https://img.youtube.com/vi/${videoId}/hqdefault.jpg`
        : "";
    } catch {
      return "";
    }
  };

  const handlePlayVideo = () => {
    setIsPlaying(true);
  };

  // Don't render anything if videoUrl is not valid
  if (!videoUrl) return null;

  return (
    <div className="p-4 rounded-lg bg-primary border border-bordercolor">
      <div className="text-lg font-medium text-textcolor font-poppins mb-4">
        Video
      </div>

      <div className="w-full flex flex-col gap-4 relative">
        {isYouTube(videoUrl) ? (
          <div className="relative w-full rounded-xl">
            {!isPlaying ? (
              <div
                className="relative w-full h-[200px] md:h-[315px] rounded-xl cursor-pointer"
                onClick={handlePlayVideo}
              >
                <img
                  src={getYouTubeThumbnail(videoUrl)}
                  alt="Video Thumbnail"
                  className="w-full h-full object-cover rounded-lg"
                />
                <div className="absolute inset-0 flex items-center justify-center bg-black/50 rounded-lg">
                  <img src={playvideobtn} alt="Play" width={50} height={50} />
                </div>
              </div>
            ) : (
              <iframe
                src={getYouTubeEmbedUrl(videoUrl)}
                title="YouTube Player"
                className="w-full h-[315px] rounded-lg"
                frameBorder="0"
                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                allowFullScreen
              ></iframe>
            )}
          </div>
        ) : isVimeo(videoUrl) ? (
          <iframe
            src={getVimeoEmbedUrl(videoUrl)}
            title="Vimeo Player"
            className="w-full h-[315px] rounded-lg"
            frameBorder="0"
            allow="autoplay; fullscreen; picture-in-picture"
            allowFullScreen
          ></iframe>
        ) : isVideoFile(videoUrl) ? (
          <div className="relative w-full">
            <ReactPlayer
              ref={playerRef}
              url={videoUrl}
              controls
              playing={isPlaying}
              width="100%"
              height="315px"
              className="rounded-lg"
            />
            {!isPlaying && (
              <button
                onClick={handlePlayVideo}
                className="absolute inset-0 flex items-center justify-center bg-black/50 rounded-lg"
              >
                <img src={playvideobtn} alt="Play" width={50} height={50} />
              </button>
            )}
          </div>
        ) : (
          <p className="text-red-500">Invalid video URL</p>
        )}
      </div>
    </div>
  );
}

export default VideoSectionDetailScreen;
