import React, { useEffect } from 'react';
import WithoutSorttableHeader from '../../../../Componets/TableComponets/WithoutSorttableHeader';
import notfound from "../../../../assets/Images/notfound.png";
import AvatarWithSpinner from '../../../../Componets/LoadingComponest';
import useApiPost from '../../../../Hooks/PostData';
import TableUserInfo from '../../../../Componets/TableComponets/TableUserInfo';
import SimpletextTableBody from '../../../../Componets/TableComponets/SimpletextTableBody';
import SimpletextTableBodyReview from '../../../../Componets/TableComponets/SimpletextTableBodyReview';
import TableDateTimeDisplay from '../../../../Componets/TableComponets/TableDateTimeDisplay';
import TableActionButtons from '../../../../Componets/TableComponets/TableActionButtons';
import Block from "../../../../assets/Images/deleteicon.png"
import { useAppDispatch, useAppSelector } from '../../../../Hooks/Hooks';
import { reset } from '../../../../Appstore/Slice/toggleSlice';
import { showModal } from '../../../../Appstore/Slice/ModalSlice';

function StoreReviewDetail() {
    const { data, loading, postData } = useApiPost();
    const storIDViews = sessionStorage.getItem("storIDViews");
    const dispatch = useAppDispatch()


    const apicall = useAppSelector((state) => state.toggle.value)

    useEffect(() => {
        if (storIDViews) {
            postData("/service-reviewlist", { service_id: storIDViews });
        }
    }, [storIDViews]);


    useEffect(() => {
        if (apicall) {
            postData("/service-reviewlist", { service_id: storIDViews });
        }
    }, [apicall])

    const handleBlock = (id: number) => {
        console.log("Block review with ID:", id);
        dispatch(reset())
        dispatch(showModal("DeleteReviewViewStore"))
        sessionStorage.setItem("StorereviewID", id.toString())
    };

    return (
        <div className="p-4">
            <div className="relative border border-bordercolor rounded-lg mt-8 mx-4 sm:mx-0 overflow-x-auto w-full">
                <div className="min-w-[1200px]">
                    {/* Table Header */}
                    <div className="flex items-center px-4 py-4 text-left border-b bg-headercolortable border-b-bordercolor sm:pl-8 gap-4">
                        <div className="w-[3%]"><WithoutSorttableHeader label="S.L" /></div>
                        <div className="w-[22%]"><WithoutSorttableHeader label="REVIEWER" /></div>
                        <div className="w-[20%]"><WithoutSorttableHeader label="STORE" /></div>
                        <div className="w-[5%]"><WithoutSorttableHeader label="STAR" /></div>
                        <div className="w-[30%]"><WithoutSorttableHeader label="REVIEW" /></div>
                        <div className="w-[15%]"><WithoutSorttableHeader label="CREATED DATE/TIME" /></div>
                        <div className="w-[5%]"><WithoutSorttableHeader label="ACTION" /></div>
                    </div>

                    {/* Table Body */}
                    <div className="relative">
                        {loading ? (
                            <div className="h-[400px] flex items-center justify-center">
                                <AvatarWithSpinner />
                            </div>
                        ) : data?.reviewlist?.length > 0 ? (
                            data.reviewlist.map((review: any, index: number) => (
                                <div
                                    key={review.id}
                                    className={`flex items-start px-4 py-4 border-b border-b-bordercolor sm:pl-8 gap-4 text-sm ${index % 2 === 0 ? 'bg-white dark:bg-primary' : 'bg-[#00162e0a] dark:bg-primary'
                                        }`}
                                >
                                    {/* SL */}
                                    <div className="w-[3%] pt-2 text-textcolor">{index + 1}</div>

                                    {/* Reviewer Info */}
                                    <div className="w-[22%]">
                                        <TableUserInfo
                                            profilePic={review.image || ""}
                                            username={`${review.first_name} ${review.last_name}`}
                                            email={review.email || 'N/A'}
                                            mobile={review.country_code ? `${review.country_code} ${review.mobile || ''}` : 'N/A'}
                                            onClick={() => { }}
                                        />
                                    </div>

                                    {/* Store Info */}
                                    <div className="w-[20%] flex items-center gap-2">
                                        <div className="w-12 h-12 rounded-full overflow-hidden shrink-0">
                                            <img
                                                src={review.service_images?.[0] || notfound}
                                                className="w-full h-full object-cover"
                                                alt="Store"
                                            />
                                        </div>
                                        <SimpletextTableBody title={review.service_name} />
                                    </div>

                                    {/* Star Rating */}
                                    <div className="w-[5%] pt-2">
                                        <SimpletextTableBody title={review.review_star} />
                                    </div>

                                    {/* Review Message */}
                                    <div className="w-[30%] whitespace-pre-wrap break-words text-textcolor">
                                        <SimpletextTableBodyReview title={review.review_message} />
                                    </div>

                                    {/* Created At */}
                                    <div className="w-[15%]">
                                        <TableDateTimeDisplay dateString={review.created_at} />
                                    </div>

                                    {/* Action Buttons */}
                                    <div className="w-[5%] flex items-center gap-2">
                                        <TableActionButtons
                                            onBlockClick={() => handleBlock(review.id)}
                                            blockButtonColor="#FDE4EA"
                                            borderColor="#01D312"
                                            blockButtonIcon={Block}
                                        />
                                    </div>
                                </div>
                            ))
                        ) : (
                            <div className="p-4 h-[38rem] flex justify-center items-center">
                                <div className="w-full flex flex-col items-center">
                                    <img
                                        src={notfound}
                                        alt="Not Found"
                                        className="w-1/2 max-h-[40vh] object-contain"
                                    />
                                    <h2 className="font-poppins text-lg text-textcolor mt-4">
                                        No Reviews Found
                                    </h2>
                                </div>
                            </div>
                        )}
                    </div>
                </div>
            </div>
        </div>
    );
}

export default StoreReviewDetail;
