"use client";
import { useEffect, useRef } from "react";
import { useDispatch } from "react-redux";
import { CiSearch } from "react-icons/ci";
import { useGoogleMaps } from "../../../Hooks/useGoogleMaps";
import { useAppSelector } from "../../../Hooks/Hooks";
import { setLocation } from "../../../Appstore/Slice/locationSlice";
import CurrentLocation from "../../../Componets/CurrentLocation/CurrentLocation";

const GoogleMapLocationUpdate = () => {
    const dispatch = useDispatch();
    const googleLoaded = useGoogleMaps();


    const formData = useAppSelector((state) => state.service.service);

    const latvalues = parseFloat(formData?.lat || "23.0225");
    const lonvalues = parseFloat(formData?.lon || "72.5714");

    console.log(" my update location lat lon values" ,formData?.lat , formData?.lon )

    const mapRef = useRef<google.maps.Map | null>(null);
    const markersRef = useRef<google.maps.Marker[]>([]);

    useEffect(() => {
        if (googleLoaded && latvalues && lonvalues) {
            initAutocomplete(latvalues, lonvalues);
        }
    }, [googleLoaded, latvalues, lonvalues]);


  


    const initAutocomplete = (lat: number, lng: number) => {
        const input = document.getElementById("pac-input") as HTMLInputElement;
        const mapDiv = document.getElementById("map");

        if (!window.google || !input || !mapDiv) return;

        // Clean up any previous markers
        markersRef.current.forEach((marker) => marker.setMap(null));
        markersRef.current = [];

        // Initialize or update map
        if (!mapRef.current) {
            mapRef.current = new google.maps.Map(mapDiv, {
                center: { lat, lng },
                zoom: 13,
                mapTypeId: google.maps.MapTypeId.ROADMAP,
            });

            const searchBox = new google.maps.places.SearchBox(input);

            mapRef.current.addListener("bounds_changed", () => {
                searchBox.setBounds(mapRef.current!.getBounds() as google.maps.LatLngBounds);
            });

            searchBox.addListener("places_changed", () => {
                const places = searchBox.getPlaces();
                if (!places || places.length === 0) return;

                markersRef.current.forEach((marker) => marker.setMap(null));
                markersRef.current = [];

                const bounds = new google.maps.LatLngBounds();

                places.forEach((place) => {
                    if (!place.geometry || !place.geometry.location) return;

                    const marker = new google.maps.Marker({
                        map: mapRef.current!,
                        position: place.geometry.location,
                        title: place.formatted_address,
                    });

                    markersRef.current.push(marker);

                    if (place.geometry.viewport) {
                        bounds.union(place.geometry.viewport);
                    } else {
                        bounds.extend(place.geometry.location);
                    }

                    const newLat = place.geometry.location.lat();
                    const newLng = place.geometry.location.lng();

                    dispatch(
                        setLocation({
                            name: place.formatted_address || "",
                            location: place.geometry.location,
                            vicinity: place.name || "",
                            lat: newLat,
                            lng: newLng,
                        })
                    );
                });

                mapRef.current!.fitBounds(bounds);
            });
        } else {
            mapRef.current.setCenter({ lat, lng });
        }
    };

    return (
        <div className="relative flex h-[25rem] md:h-[20rem] xl:h-full w-full  flex-col rounded-xl">
            {/* Search input absolutely positioned on top center */}

            <div className="absolute top-[-0.3rem] left-1/2   w-full -translate-x-1/2">
                <label className="font-poppins text-sm font-normal text-textcolor">
                    Store Location
                    <span className="text-[#F21818] pl-[1px]">*</span>
                </label>
                <div className="relative w-full">

                    <input
                        id="pac-input"
                        className="input-important w-full z-10 rounded-lg border p-4 pl-10 text-sm outline-none shadow-md"
                        type="text"
                        placeholder="Search for area, street name"
                    />
                    <CiSearch className="absolute left-3 top-1/2 -translate-y-1/2 transform text-xl text-gray-500" />
                </div>
            </div>

            {/* Map container */}
            <div
                id="map"
                className="flex-1 rounded-xl mt-[5.5rem]"
                style={{ minHeight: "300px", height: "100%", width: "100%" }}
            />

            <div className=" hidden">
                <CurrentLocation />
            </div>
        </div>
    );
};

export default GoogleMapLocationUpdate;
