import React, { useEffect, useState } from "react";
import { MdOutlineChevronRight } from "react-icons/md";
import { useAppDispatch, useAppSelector } from "../../../Hooks/Hooks";
import { updateAddPostData } from "../../../Appstore/Slice/Storevalues/AddStoreSlice";
import { updateServiceField } from "../../../Appstore/Slice/StoreUpdate/serviceSlice";

const hours = [
    "12 AM", "1 AM", "2 AM", "3 AM", "4 AM", "5 AM", "6 AM",
    "7 AM", "8 AM", "9 AM", "10 AM", "11 AM", "12 PM",
    "1 PM", "2 PM", "3 PM", "4 PM", "5 PM", "6 PM",
    "7 PM", "8 PM", "9 PM", "10 PM", "11 PM"
];

function CloseTimeUpdate() {
    const dispatch = useAppDispatch();
    const closeTime = useAppSelector((state) => state.service.service?.close_time);

    const [searchValue, setSearchValue] = useState("");
    const [showDropdown, setShowDropdown] = useState(false);
    const [rotate, setRotate] = useState(false);

    useEffect(() => {
        if (closeTime) {
            setSearchValue(closeTime);
        }
    }, [closeTime]);

    const handleToggle = () => {
        setShowDropdown((prev) => !prev);
        setRotate((prev) => !prev);
    };

    const handleFocus = () => {
        setShowDropdown(true);
        setRotate(true);
    };

    const handleBlur = () => {
        setTimeout(() => {
            setShowDropdown(false);
            setRotate(false);
        }, 150);
    };

    const handleSelect = (hour: string) => {
        setSearchValue(hour);
        dispatch(updateServiceField({ key: "close_time", value: hour }));
        setShowDropdown(false);
        setRotate(false);
    };

    const filteredHours = hours.filter((hour) =>
        hour.toLowerCase().includes(searchValue.toLowerCase())
    );

    return (
        <div className="w-full flex flex-col relative h-full">
            <label htmlFor="close-time" className="font-poppins text-sm font-medium text-textcolor">
                Close Time <span className="text-[#F21818] pl-[1px]">*</span>
            </label>

            <div className="relative mt-1 flex items-center cursor-pointer">
                <input
                    type="text"
                    id="close-time"
                    autoComplete="off"
                    spellCheck="false"
                    className="w-full rounded-lg border border-bordercolor cursor-pointer focus:border-blue-500 text-textcolor bg-primary px-4 py-2.5 my-1 placeholder:text-placeholdercolor placeholder:text-sm focus:outline-none"
                    placeholder="Select hour"
                    value={searchValue}
                    onChange={(e) => {
                        const val = e.target.value;
                        setSearchValue(val);
                        if (val === "") {
                            // clear the slice value when input is cleared
                            dispatch(updateAddPostData({ close_time: "" }));
                        }
                    }}
                    onFocus={handleFocus}
                    onBlur={handleBlur}
                />
                <div
                    className={`absolute right-2 text-xl cursor-pointer transition-transform ${rotate ? "rotate-90" : "-rotate-90"}`}
                    onClick={handleToggle}
                >
                    <MdOutlineChevronRight />
                </div>
            </div>

            {showDropdown && (
                <ul className="absolute top-[5rem] left-0 w-full bg-white text-textcolor rounded-lg shadow-lg max-h-[200px] overflow-y-auto z-10 border border-bordercolor mt-1">
                    {filteredHours.length > 0 ? (
                        filteredHours.map((hour) => (
                            <li
                                key={hour}
                                className="px-4 py-2 font-poppins text-sm hover:bg-gray-100 cursor-pointer"
                                onMouseDown={() => handleSelect(hour)}
                            >
                                {hour}
                            </li>
                        ))
                    ) : (
                        <li className="px-4 py-2 font-poppins text-center text-gray-500">
                            No matching time
                        </li>
                    )}
                </ul>
            )}
        </div>
    );
}

export default CloseTimeUpdate;
