import React, { useEffect } from 'react';
import StoreImageUpdate from './StoreImageUpdate';
import FormGlobalInputAnalytical from '../../../Componets/Form/FormGlobalINputNlytical';
import { useAppDispatch, useAppSelector } from '../../../Hooks/Hooks';
import { updateStoreValues, updateServiceField } from '../../../Appstore/Slice/StoreUpdate/serviceSlice';
import toast from 'react-hot-toast';
import useApiPost from '../../../Hooks/PostData';
import { reset, setTrue } from '../../../Appstore/Slice/toggleSlice';
import { clearAllCoverImages } from '../../../Appstore/Slice/UploadAddserviceImageSlice';
import StoreCoverImageUpdate from './ StoreCoverImageUpdate';

interface ServiceUpdateResponse {
  status: boolean;
  message: string;
  service: any;
  service_images: { id: number; service_images: string }[];
  cover_image: string;
}

function UpdateMedia() {
  const dispatch = useAppDispatch();
  const serviceState = useAppSelector((state) => state.service);
  const coverImage = useAppSelector((state) => state.UploadServiceAttactmentSlice.cover_image);
  const Storeimage = useAppSelector((state) => state.UploadAddserviceImageSlice);
  const isapicall = useAppSelector((state) => state.toggle.value);
  const videoUrl = serviceState.service?.video_url || '';

  const service_id = sessionStorage.getItem("storID");
  const { loading, postData, data } = useApiPost();

  const handleChange = (e: React.ChangeEvent<HTMLInputElement>) => {
    dispatch(updateServiceField({ key: 'video_url', value: e.target.value }));
  };


  const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';



  const handalsubmit = async () => {

    if (IS_DEMO) {
      toast.error("This action is disabled in the demo version.");
      return;
    }
    if (!service_id) return toast.error("Service ID not found");

    dispatch(reset());

    const payload = new FormData();
    payload.append("service_id", service_id);

    if (coverImage) payload.append("cover_image", coverImage);

    if (videoUrl) payload.append("video_url", videoUrl);

    Storeimage.cover_images.forEach((file: File) => {
      payload.append('service_images[]', file);
    });

    try {
      const response = await postData("/edit-service", payload, "multipart/form-data");
      toast.success("Update successful");
      dispatch(setTrue());
      dispatch(clearAllCoverImages());
    } catch (err) {
      toast.error("Update failed");
    }
  };

  useEffect(() => {
    if (isapicall && service_id) {
      const payload = new FormData();
      payload.append("service_id", service_id);
      postData("/edit-service", payload);
    }
  }, [isapicall]);

  useEffect(() => {
    if (data?.status && data?.service) {
      const response = data as ServiceUpdateResponse;
      dispatch(
        updateStoreValues({
          service: response.service,
          service_images: response.service_images,
          cover_image: response.cover_image,
        })
      );
    }
  }, [data, dispatch]);

  return (
    <div className="w-full flex flex-col mt-4 md:mt-0 p-6 border border-bordercolor rounded-lg gap-6">
      <div className="w-full h-fit grid md:grid-cols-2 gap-4">
        <StoreCoverImageUpdate />
        <StoreImageUpdate />
      </div>

      <div className="w-full">
        <FormGlobalInputAnalytical
          label="Video URL"
          name="video_url"
          value={videoUrl}
          onChange={handleChange}
          required
          placeholder="Enter Video URL"
        />
      </div>

      <div className="w-full flex justify-center items-center">
        <button
          className="w-fit px-[3rem] py-2 bggradient rounded-lg cursor-pointer font-poppins text-white"
          onClick={handalsubmit}
          disabled={loading}
        >
          {loading ? "Updating..." : "Update"}
        </button>
      </div>
    </div>
  );
}

export default UpdateMedia;
