import React, { useState, useRef, useMemo, useEffect } from "react";
import { useDispatch } from "react-redux";
import JoditEditor from "jodit-react";
import { useAppSelector } from "../../../Hooks/Hooks";
import { updateSubplanData } from "../../../Appstore/Slice/AddSubcriptionDescription";
import { updateServiceField } from "../../../Appstore/Slice/StoreUpdate/serviceSlice";

const MetaDescriptionUpdate = () => {
    const dispatch = useDispatch();
    const editor = useRef(null);
    const [content, setContent] = useState("");

    const service_description12 = useAppSelector(
        (state) => state.service.service?.meta_description || ""
    );


    useEffect(() => {
        // Set initial description when loaded from redux
        setContent(service_description12);
    }, [service_description12]);


    const config = useMemo(
        () => ({
            readonly: false,
            placeholder: "Meta Description typing..." || "Service description typing...",
            toolbar: true,
            buttons: [
                "bold",
                "italic",
                "underline",
                "strike",
                "|",
                "font",
                "fontsize",
                "forecolor",
                "backcolor",
                "|",
                "ul",
                "ol",
                "outdent",
                "indent",
                "|",
                "align",
                "alignleft",
                "aligncenter",
                "alignright",
                "alignjustify",
                "|",
                "link",
                "image",
                "table",
                "video",
                "|",
                "undo",
                "redo",
                "removeformat",
                "clear",
                "|",
                "fullsize",
            ],
            spellcheck: true,
            showCharsCounter: false,
            showWordsCounter: false,
            height: 400,

            // 👇 This line disables the paste HTML popup
            askBeforePasteHTML: false,

            // Optional: Also clean inline styles from pasted content
            cleanHTML: {
                removeStyles: true,
                removeTags: ["style", "script"],
            },
        }),
        []
    );


    const handleContentChange = (newContent: string) => {
        setContent(newContent);
        dispatch(updateServiceField({ key: "meta_description", value: newContent }));
    };

    return (
        <div className=" w-full  overflow-hidden">
            <label
                className="block text-sm font-medium font-poppins text-[#000000]"
                htmlFor="businessDescription"
            >
                Meta Description<span className="text-[#FF0000]"> *</span>
            </label>
            <div className="mt-2">
                <JoditEditor
                    ref={editor}
                    value={service_description12}
                    config={config}
                    tabIndex={1}
                    onBlur={(newContent) => handleContentChange(newContent)}
                    onChange={(newContent) => handleContentChange(newContent)}
                />
            </div>
        </div>
    );
};

export default MetaDescriptionUpdate;
