import { useEffect, useState } from 'react'
import { useSelector } from 'react-redux';
import { Link, useNavigate } from 'react-router-dom';
import Add from "../../assets/Images/add.png"
import SearchBar from '../../Componets/SearchBar/SearchBar';
import WithoutSorttableHeader from '../../Componets/TableComponets/WithoutSorttableHeader';
import useApiPost from '../../Hooks/PostData';
import notfound from "../../assets/Images/notfound.png"
import { useAppDispatch, useAppSelector } from '../../Hooks/Hooks';
import Loader from "../../assets/Images/Loader.gif"
import SimpletextTableBody from '../../Componets/TableComponets/SimpletextTableBody';
import TableDateTimeDisplay from '../../Componets/TableComponets/TableDateTimeDisplay';
import toast from 'react-hot-toast';
import Apimethod from '../../Hooks/Apimethod';
import GiftCategoryPagination from '../../Componets/PaginationComponets/GiftCategoryPagination';
import { setPaginationCategoryList } from '../../Appstore/Slice/PaginationSlice/GiftCategorySlice';
import { showModal } from '../../Appstore/Slice/ModalSlice';
import { reset } from '../../Appstore/Slice/toggleSlice';
import TableUserInfo from '../../Componets/TableComponets/TableUserInfo';
import TableActionButtons from '../../Componets/TableComponets/TableActionButtons';
import Eye from "../../assets/Images/eye.png"
import AvatarWithSpinner from '../../Componets/LoadingComponest';
import Search from '../../assets/Images/search.png';
import { resetall } from '../../Appstore/Slice/AddVendorSlice';
import { clearCoverImageatc } from '../../Appstore/Slice/UploadServiceAttactmentSlice';

function VendorList() {

    const isSidebarOpen = useSelector((state: any) => state.sidebar.isOpen);
    const { data, loading, error, postData } = useApiPost();
    const [search, setSearch] = useState("")


    const navigate = useNavigate();


    const pagination = useAppSelector((state) => state.GiftCategorySlice);
    const { current_page, records_per_page } = pagination;


    const [toggleStates, setToggleStates] = useState<{ [key: number]: boolean }>({});

    // Fetch data
    useEffect(() => {
        const params = {
            page: current_page,
            pageSize: records_per_page,
            search: search.trim()


        };

        postData("/vendors-list", params);
    }, [current_page, records_per_page, search]);



    const isaddgiftvalues = useAppSelector((state) => state.toggle.value)


    useEffect(() => {

        if (isaddgiftvalues) {
            postData("/vendors-list", {});
        }

    }, [isaddgiftvalues])




    useEffect(() => {
        if (data?.vendors) {
            const toggles = data.vendors.reduce((acc, gift) => {
                acc[gift.id] = gift.status;
                return acc;
            }, {} as { [key: number]: boolean });
            setToggleStates(toggles);
        }
    }, [data]);



    const dispatch = useAppDispatch()


    useEffect(() => {
        if (data?.Pagination) {
            dispatch(setPaginationCategoryList(data?.Pagination));
        }
    }, [data, dispatch]);



    const { makeRequest } = Apimethod()

    const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';


    const handleToggleStatus = async (giftId: number) => {


        if (IS_DEMO) {
            toast.error("This action is disabled in the demo version.");
            return;
        }
        const newStatus = !toggleStates[giftId];
        try {
            await makeRequest(
                "/user-statuschange",
                {
                    id: giftId,
                    status: newStatus ? 1 : 0, // convert boolean to 1 or 0
                },
                "application/json",
                "POST"
            );
            setToggleStates((prev) => ({
                ...prev,
                [giftId]: newStatus,
            }));
            toast.success("Status changed successfully");
        } catch (err) {
            toast.error("Failed to update status");
        }
    };




    // Action handlers
    const handleOpenStory = (user: any) => {
        console.log("my all user detail@", user);
        navigate("/View-Vendor");
        sessionStorage.setItem("user_id", user.id)


    };


    const handaladdvendor = () => {
        navigate(`/add-vendor`);
        dispatch(reset())
        dispatch(resetall())
        dispatch(clearCoverImageatc())
    }

    return (
        <div className={`bg-primary ${isSidebarOpen ? "xl:pl-20" : "xl:pl-72"}`}>
            <SearchBar />
            <div className="px-4 pb-10 xl:px-6">
                <div className="flex justify-between border-t-[#F2F2F2] py-3">
                    <h2 className="text-textcolor font-poppins text-xl font-semibold pt-3 ">Vendor List</h2>
                    <div className="relative">
                        <div className="absolute left-2 top-1/2 flex transform -translate-y-1/2 items-center p-2">
                            <img src={Search} alt="Search" className="h-4 w-4 md:h-5 md:w-5" />
                        </div>
                        <div className=' w-full'>
                            <input
                                type="text"
                                placeholder="Search by name ,email..."
                                className="w-[180px] md:w-[250px] pl-10 text-textcolor py-2 text-sm placeholder:text-placeholdercolor
              border border-bordercolor border-opacity-10 rounded-lg bg-[#00000005] 
              focus:outline-none focus:ring-1 focus:ring-gray-600 
              placeholder:dark:text-tableDarkLarge "

                                onChange={(e) => setSearch(e.target.value)}
                                value={search}
                            />
                        </div>
                    </div>
                </div>

                <div className="flex items-center flex-col  gap-y-5 xl:flex-row justify-between">
                    <div className="flex items-center gap-2">
                        <Link to="/dashboard">
                            <h3 className="text-[#3A3A3A] font-poppins text-base  font-semibold">Dashboard</h3>
                        </Link>
                        <div className="rounded-full w-1 h-1 bg-[#E0E0E0]"></div>
                        <h3 className="text-[#858585] font-poppins text-base">Vendor List</h3>
                    </div>

                    <button
                        className="flex gap-1.5 mr-1 py-2 cursor-pointer place-items-center px-4 font-poppins font-medium text-white rounded-md bggradient"
                        onClick={handaladdvendor}
                    >
                        <img src={Add} className="w-4 h-4" />
                        <p className="md:text-sm text-xs">Add Vendor</p>
                    </button>
                </div>


                <div className="relative border border-bordercolor rounded-lg mt-8 mx-4 sm:mx-0 overflow-x-auto w-full">
                    <div className="min-w-[1200px]">
                        <div className="flex px-4 py-3 text-left border-b w-full bg-headercolortable border-b-bordercolor sm:pl-8">
                            <div className="w-[5%]"><WithoutSorttableHeader label="S.L" /></div>
                            <div className="w-[20%]"><WithoutSorttableHeader label="VENDOR" /></div>
                            <div className="w-[22%]"><WithoutSorttableHeader label="USERNAME" /></div>
                            <div className="w-[20%]"><WithoutSorttableHeader label="CREATED DATE/TIME" /></div>
                            <div className="w-[13%]"><WithoutSorttableHeader label="CONTACT NUMBER" /></div>
                            <div className="w-[10%]"><WithoutSorttableHeader label="STATUS" /></div>
                            <div className="w-[10%]"><WithoutSorttableHeader label="ACTIONS" /></div>
                        </div>


                        <div className="relative">
                            {loading && (
                                <div className=" h-[400px] flex items-center justify-center  ">
                                    <AvatarWithSpinner />
                                </div>
                            )}

                            {!loading && data?.vendors?.length > 0 ? (
                                data.vendors.map((gift: any, index: number) => (
                                    <div key={gift.gift_id} className={`    ${index % 2 === 0 ? 'bg-white dark:bg-primary' : 'bg-[#00162e0a] dark:bg-primary'
                                        } flex items-center px-4 py-3 border-b border-b-bordercolor sm:pl-8`}>
                                        <div className="w-[5%] text-sm text-textcolor font-poppins">
                                            {(current_page - 1) * records_per_page + index + 1}
                                        </div>
                                        <div className=' w-[20%]'>
                                            <TableUserInfo
                                                profilePic={gift.image}
                                                username={`${gift.first_name} ${gift.last_name}`} // Added space between first and last name
                                                email={gift.email || 'N/A'}
                                                mobile={gift.country_code ? `${gift.country_code} ${gift.mobile || ''}` : 'N/A'}
                                                onClick={() => handleOpenStory(gift)}
                                            />
                                        </div>

                                        <div className=' w-[22%]'>
                                            <SimpletextTableBody title={gift.username} />
                                        </div>
                                        <div className=' w-[20%]'>
                                            <TableDateTimeDisplay dateString={gift.created_at} />
                                        </div>

                                        <div className=' w-[13%]'>
                                            <SimpletextTableBody title={gift.mobile} />
                                        </div>

                                        <div className=' w-[10%] '>
                                            <label className="flex items-center cursor-pointer select-none">
                                                <div className="relative">
                                                    <input
                                                        type="checkbox"
                                                        checked={toggleStates[gift.id] || false}
                                                        onChange={() => handleToggleStatus(gift.id)}
                                                        className="sr-only"
                                                    />
                                                    <div className={`block h-6 w-10 rounded-full border transition duration-300 ${toggleStates[gift.id] ? " border-toggalbtcolorborder bggradient" : "bg-transparent  border  border-toggalbtcolorborder"}`}></div>
                                                    <div className={`absolute top-1 h-4 w-4 rounded-full transition duration-300 ${toggleStates[gift.id] ? "right-1 bg-white" : "left-1 bggradient"}`}></div>
                                                </div>
                                            </label>
                                        </div>

                                        <div className=' w-[10%]'>
                                            <TableActionButtons
                                                viewButtonIcon={Eye}
                                                onViewClick={() => handleOpenStory(gift)}
                                                viewButtonColor="#CCE1CD"
                                                borderColor="#01D312"
                                            />
                                        </div>


                                    </div>
                                ))
                            ) : !loading &&

                            <div className="p-4 h-[38rem] flex justify-center items-center">
                                <div className="w-full flex flex-col items-center h-full justify-center">
                                    <img
                                        src={notfound}
                                        alt="Not Found"
                                        className="w-1/2 max-h-[40vh] object-contain"
                                    />
                                    <h2 className="font-poppins text-lg text-textcolor  mt-4">
                                        No  Data Found
                                    </h2>
                                </div>
                            </div>

                            }
                        </div>
                    </div>

                    <GiftCategoryPagination />
                </div>
            </div>

        </div>
    )
}

export default VendorList
