import React from 'react'
import { UseGetVendordetail } from '../../../Appstore/Api/UseGetVendordetail'
import calll from "../../../assets/Images/call12.png"
import email from "../../../assets/Images/email.png"

function VendorDetail() {
    const { data, isLoading } = UseGetVendordetail()

    return (
        <div className='w-full p-4 relative rounded-lg h-[15rem] border border-bordercolor flex flex-col items-center justify-center text-center'>
            {/* "Vendor" Badge */}
            <div className='absolute top-5 left-0'>
                <div className='w-fit rounded-r-lg text-[#0046AE] font-medium cursor-pointer bg-[#0046AE14] font-poppins px-2 py-1'>
                    Vendor
                </div>
            </div>

            {/* Detail Content */}
            <div className='flex flex-col items-center gap-2'>
                <div className='w-[5rem] h-[5rem] rounded-full overflow-hidden'>
                    <img
                        src={data?.vendor?.profile_photo_url}
                        alt="Profile"
                        className="w-full h-full object-cover"
                    />
                </div>

                <h3 className='font-poppins  text-textcolor font-medium text-lg'>
                    {(data?.vendor?.first_name && data?.vendor?.last_name)
                        ? `${data.vendor.first_name} ${data.vendor.last_name}`
                        : 'Service Name'}
                </h3>

                <div className='flex items-center gap-2'>
                    <img src={calll} alt="Call" className="h-4 w-4" />
                    <p className='text-sm font-normal font-poppins text-[#0046AE]'>
                        {data?.services?.[0]?.service_phone || 'Phone Number'}
                    </p>
                </div>

                <div className='flex items-center gap-2'>
                    <img src={email} alt="Email" className="h-4 w-4" />
                    <p className='text-sm font-normal font-poppins text-[#0046AE]'>
                        {data?.vendor?.email || 'Email Address'}
                    </p>
                </div>
            </div>
        </div>
    )
}

export default VendorDetail
